package com.db4o.samples.callbacks;

import com.db4o.*;
import com.db4o.samples.*;

public class C01_CascadeOnNew
{
	// Attention!!  This file is deleted on running this class.
	public static final String FILE = "callbacks.yap";
	
	public static void main(String[] args){
		
		Db4o.configure().messageLevel(-1);
		
		
		// create a ListOnNew object with the member value 5
		// store it and watch the effect of ListOnNew#objectOnNew 
		new C01_CascadeOnNew().set(new ListOnNew(5));
		
	}
	
	public void set(ListSample newList){
		new java.io.File(FILE).delete();
		ObjectContainer con = Db4o.openFile(FILE);
		con.set(newList);
		con.close();
		logLists();
	}
	
	public void logLists(){
		ObjectContainer con = Db4o.openFile(FILE);
		ObjectSet set = con.get(new ListSample());
		while(set.hasNext()){
			ListSample list = (ListSample)set.next();
			
			// the following two lines ensure that we don't log 
			// member lists multiple times
			// See the code in the samples subfolder "activate" to 
			// learn more about activation.
			con.activate(list,1);
			con.deactivate(list.next,1);
			
			com.db4o.tools.Logger.log(con,list);
		}
		con.close();
	}
}

