package com.db4o.samples.activate;

import com.db4o.*;
import com.db4o.samples.*;
import com.db4o.tools.*;

/**
 * demonstrates deactivation.
 * Deactivate allows manual memory management for critical evironments.
 * All object field values are set to null.
 * All simple type field values are set to their default values.
 */	
public class A05_Deactivate extends A01_Store_List
{
	public static void main(String[] args){
		Db4o.configure().messageLevel(-1);
		
		ObjectContainer con = Db4o.openFile(FILE);
		
		// Log the root list element with all attached elements
		System.out.println("The root element.");
		ListSample list1 = (ListSample)con.get(new ListSample(1)).next();
		con.activate(list1, Integer.MAX_VALUE);
		Logger.log(con,list1);
		
		// Use a new query to get element 5
		System.out.println("Element 5");
		ListSample list5 = (ListSample)con.get(new ListSample(5)).next();
		con.activate(list5, Integer.MAX_VALUE);
		Logger.log(con, list5);
		
		// This one is obvious
		System.out.println("Root element after deactivate.");
		con.deactivate(list1,5);
		Logger.log(con,list1);
		
		
		// DANGER !!!.
		// If you use deactivate with a higher value than 1
		// make sure that you know whereto members might branch
		// Deactivating list1 also deactivated list5
		System.out.println("Element 5 AFTER DEACTIVATE OF LIST1.");
		Logger.log(con,list5);
		
		
		// Of course you can activate objects again at any time.
		System.out.println("Element 5 after activating it again.");
		con.activate(list5,10);
		Logger.log(con,list5);
		
		con.close();
	}
}
