package com.db4o.samples.activate;

import com.db4o.*;

/**
 * demonstrates the use of ObjectClass#minimumActivationDepth()
 */
public class A03_Class_Minimum_Activation_Depth extends A02_Global_Activation_Depth
{
	public static void main(String[] args){
		Db4o.configure().messageLevel(-1);
		Db4o.configure().activationDepth(2);
		
		// a global activation depth of 2 for a short output log.
		System.out.println("GLOBAL ACTIVATION DEPTH OF 2");
		run();
		
		System.out.println("MINIMUM ACTIVATION DEPTH OF 2 FOR LIST CLASS");
		
		// note that the minimum applies for *all* instances in the hierarchy
		// the system ensures that every instantiated List object will have it's 
		// members set to a depth of 1
		Db4o.configure().objectClass("com.db4o.samples.List").minimumActivationDepth(1);
		
		run();
	}
}
