package com.db4o.samples.activate;

import com.db4o.*;
import com.db4o.samples.*;

/**
 * demonstrates the usage of Configuration.activationDepth()
 */
public class A02_Global_Activation_Depth extends A01_Store_List
{
	public static void main(String[] args){
		
		Db4o.configure().messageLevel(-1);
		
		System.out.println("DEFAULT ACTIVATION DEPTH");
		run();
		
		System.out.println("ACTIVATION DEPTH 8");
		Db4o.configure().activationDepth(8);
		run();
		
		System.out.println("ACTIVATION DEPTH 2");
		Db4o.configure().activationDepth(2);
		run();
		
		System.out.println("ACTIVATION DEPTH 1");
		Db4o.configure().activationDepth(1);
		run();
		
		System.out.println("ACTIVATION DEPTH 0");
		Db4o.configure().activationDepth(0);
		run();
	}
	
	
	static void run(){
		ObjectContainer con = Db4o.openFile(FILE);
		ObjectSet set = con.get(new ListSample(1));
		while(set.hasNext()){
			ListSample list = (ListSample)set.next();
			com.db4o.tools.Logger.log(con,list);
		}
		con.close();
	}
	
}
