package com.db4o.samples.activate;

import com.db4o.*;
import com.db4o.samples.*;

/**
 * stores a new 20 element list to the database file "activate.yap".
 * The file is needed for all further samples in this folder.
 * The class com.db4o.samples.List is used.
 */	
public class A01_Store_List
{
	
	// Attention!!  This file is deleted on running this class.
	public static final String FILE = "activate.yap";
	
	
	public static void main(String[] args){
		Db4o.configure().messageLevel(-1);
		new java.io.File(FILE).delete();
		ObjectContainer con = Db4o.openFile(FILE);
		
		
		// create a linked list with length 10
		ListSample list = new ListSample().createList(10); 

		
		// store all elements with one statement, since all elements are new		
		con.set(list);  

		
		
		con.close();
		if(! (args.length > 0)){  
			logRootLists();
		}
	}
	
	
	public static void logRootLists(){
		ObjectContainer con = Db4o.openFile(FILE);
		ObjectSet set = con.get(new ListSample(1));
		while(set.hasNext()){
			ListSample list = (ListSample)set.next();
			
			
			// activate the list to the maximum depth 
			// so we are sure, we see all elements
			con.activate(list, Integer.MAX_VALUE);
			

			// com.db4o.lib.Logger is convenient to print the contents
			// of the database to System.out.
			com.db4o.tools.Logger.log(con,list);
			
		}
		con.close();
	}
	
}
