package com.db4o.samples.activate;
import com.db4o.*;

public class A00_SimpleActivationExample {
	
	public static class Book{
  		public Order order;
	}

	public static class Order{
		public Invoice invoice;
	}

	public static class Invoice{
		public Payment payment;
	}

	public static class Payment{
  		public double amount;
	}

	public static void main(String[] args) {
		Db4o.configure().messageLevel(-1);
		// Let's work with an activation depth of 3:
		Db4o.configure().activationDepth(3);
		
		// We construct an object of depth 4.
		Book book = new Book();
		book.order = new Order();
		book.order.invoice = new Invoice();
		book.order.invoice.payment = new Payment();
		book.order.invoice.payment.amount = 50;
		
		// The book is fully activated.
		// We can test this with our small test method:
		controlBookActivation(book, "before storing");
		
		
		// Open a database file
		ObjectContainer con = Db4o.openFile("activation.yap");
		
		// One call stores the complete object
		con.set(book);
		
		// now we "deactivate" the book so the cached version does 
		// not falsify our experiments.
		con.deactivate(book, Integer.MAX_VALUE);
		
		// check
		controlBookActivation(book, "after deactivation");
		
		// now we retrieve the book.
		ObjectSet set = con.get(new Book());
		Object retrievedBook = set.next();
		
		// The query instantiates the book to our configured depth of 3
		controlBookActivation(retrievedBook, "after retrieval");
		
		// now we manually activate the book completely
		con.activate(retrievedBook, Integer.MAX_VALUE);
		
		// and we should be back with our fully intantiated book graph
		controlBookActivation(retrievedBook, "after manual activation");
		
		con.close();
	}
	
	
	/** This method tests the activation depth of a passed book.*/
	public static void controlBookActivation(Object obj, String placeInProgram){
		String activationPath = "Book is deactivated";
		if(obj instanceof  Book){
			Book book = (Book)obj;			
			if(book.order != null){
				activationPath = "activated: Book";
				if(book.order.invoice != null){
					activationPath +=".order";
					if(book.order.invoice.payment != null){
						activationPath += ".invoice";
						if(book.order.invoice.payment.amount != 0){
							activationPath += ".payment";
						}
					}
				}
			}
		}
		System.out.println(placeInProgram + ": " + activationPath);
	}
}
