package com.db4o.samples;

import com.db4o.*;

public class S12_Delete
{
	public static void main(String[] args)
	{
		Db4o.configure().messageLevel(-1);
		
		try{
			ObjectContainer db = Db4o.openFile(AllSamples.FILE);
			System.out.println("*** S12 Deleting Individual where firstName is 'Alice'");

			Individual templateAlice = new Individual();
			templateAlice.firstName = "Alice";
			Individual alice = (Individual)db.get(templateAlice).next();


			// A call to delete *only* deletes the single object
			// passed as parameter.

			// Persistent members will continue to be stored in the database,
			// unless cascade-on-delete features are used.
			db.delete(alice);
			
			
			db.commit();


			db.close();

			
			// S03 is used to log the content of the database
			S03_Get_All.main(null); 

		}catch(Exception e){
			AllSamples.inARow();
		}
	}
}
