package com.db4o.samples;

import com.db4o.*;

public class S11_Update_Per_Object
{
	public static void main(String[] args)
	{
		Db4o.configure().messageLevel(-1);
		
		try{
			System.out.println("*** S11 Update Per Object");
			Individual templateAlice = new Individual();
			templateAlice.firstName = "Alice";
			templateAlice.addresses = new Address[0];
			ObjectContainer db = Db4o.openFile(AllSamples.FILE);
			Individual alice = (Individual)db.get(templateAlice).next();
		
		
			// changing the address
			alice.addresses[0].street = "Rabbit Way 1";
			
			
			// The following call does NOT update the Address in the database.
			// Every Persistent object has to be updated with 
			// an explicit call to set() individually
		
			// Only new members are added automatically upon a call to set().
			db.set(alice);
			
			
			db.commit();

		
			db.close();
			System.out.println("Alice Adress unchanged:");
			S07_Query_By_Example.main(null);  // We can use sample 7 to log Alice.
		
		
		
			// Now the right way:
			db = Db4o.openFile(AllSamples.FILE);
			alice = (Individual)db.get(templateAlice).next();
			alice.addresses[0].street = "Rabbit Way 1";
		
		
			// set() is now called for the object that was modified.
			db.set(alice.addresses[0]);
			
			
			db.commit();
		
		
			db.close();
			System.out.println("After the call to set() with alice.addresses[0]:");
			S07_Query_By_Example.main(null);  // Again sample 7 to log Alice.
		}catch(Exception e){
			AllSamples.inARow();
		}

	}
}
