package com.db4o.samples;

import com.db4o.*;

public class S10_Equality
{
	public static void main(String[] args)
	{
		Db4o.configure().messageLevel(-1);
		
		try{
			ObjectContainer db = Db4o.openFile(AllSamples.FILE);
			System.out.println("*** S10 Retrieving Individual 'Alice' and her Address.");

			Individual templateAlice = new Individual();
			templateAlice.firstName = "Alice";

			Individual alice = (Individual)db.get(templateAlice).next();
			// Object alice contains alice and her Address
			com.db4o.tools.Logger.log(db, alice);


			// We now retrieve the Address again:
			Address templateAddress = new Address();
			templateAddress.city = "Oz";
			Address alicesAddress = (Address)db.get(templateAddress).next();



			// The log output shows, that alice.addresses[0] and alicesAddress
			// are the same object.
			// db4o keeps one reference to every persistent object,
			// to make this possible
			System.out.println("Testing identity of the two instances of Address:");
			System.out.println(alice.addresses[0] == alicesAddress);


			db.close();

		}catch(Exception e){
			AllSamples.inARow();
		}
	}
}
