package com.db4o.samples;

import com.db4o.*;

public class S09_Joining_Objects
{
	public static void main(String[] args)
	{
		Db4o.configure().messageLevel(-1);
		
		try{

			ObjectContainer db = Db4o.openFile(AllSamples.FILE);
			System.out.println("*** S09 Adding all Individual to first Company as Employees");

			ObjectSet individuals = db.get(new Individual());
			ObjectSet companies = db.get(new Company());

			Company company = (Company)companies.next();
			company.employees = new Individual[individuals.size()];
			int i = 0;
			while(individuals.hasNext()){


				// The employees array on company is filled with existing
				// Individual objects retrieved from the database
				company.employees[i ++] = (Individual)individuals.next();


			}


			// A single call to set() updates the company object.
			db.set(company);
			
			
			db.commit();


			db.close();


			// we can use the By-Class-Log we created in example 4:
			S04_Get_By_Class.logByClass(Company.class);


		}catch(Exception e){
			AllSamples.inARow();
		}
	}
}
