package com.db4o.samples;

import com.db4o.*;

public class S08_Update
{
	public static void main(String[] args)
	{
		Db4o.configure().messageLevel(-1);
		
		try{
			ObjectContainer db = Db4o.openFile(AllSamples.FILE);
			System.out.println("*** S08 Updating all Individual where firstName is 'Alice'");

			Individual individual = new Individual();
			individual.firstName = "Alice";
			
			// Query By Example as in example S07
			ObjectSet os = db.get(individual);


			Person alice = (Person)os.next();
			if(alice != null){


				// modifying alice
				alice.name = "Pan";
				alice.addresses = new Address[1];
				alice.addresses[0] = new Address();
				alice.addresses[0].city = "Oz";
				alice.addresses[0].street = "One Rabbit Way";


				// calling db.set() with an object that is already stored
				// updates the object.
				// All new members are stored as well.
				db.set(alice);
				
				
				db.commit();


			}
			db.close();

			// Sample S07 is called for the convenience to output 'Alice'.
			S07_Query_By_Example.main(null);

		}catch(Exception e){
			AllSamples.inARow();
		}
	}
}
