package com.db4o.samples;

import com.db4o.*;

public class S07_Query_By_Example
{
	public static void main(String[] args)
	{
		Db4o.configure().messageLevel(-1);
		
		ObjectContainer db = Db4o.openFile(AllSamples.FILE);
		System.out.println("*** S07 Retrieving all Individual where firstName is 'Alice'");

		
		Individual alice = new Individual();
		alice.firstName = "Alice";


		// The principle of Query-By-Example is very simple.
		// db4o tries to understand the passed 'template' object.
		// All matching objects are delivered in the resultset.
		ObjectSet os = db.get(alice);


		while(os.hasNext()){
			com.db4o.tools.Logger.log(db, os.next());
		}
		db.close();
	}
}
