package com.db4o.samples;

import com.db4o.*;

public class S04_Get_By_Class
{
	public static void main(String[] args)
	{
		Db4o.configure().messageLevel(-1);
		
		ObjectContainer db = Db4o.openFile(AllSamples.FILE);
		System.out.println("*** S04 Retrieving all objects of class Address");


		// A first introduction to Query-By-Example:
		// What you give is what you get!
		// If you specify an object, with no members set,
		// you get all objects of the class.
		ObjectSet os = db.get(new Address());

		// Note that you have to watch out for constructor side effects here.
		// If the constructor sets any members, they will be evaluated against
		// the stored objects.


		while(os.hasNext()){
			com.db4o.tools.Logger.log(db, os.next());
		}
		db.close();
	}


	public static void logByClass(Class clazz){

		// We implement the above a little bit more generic to be used again
		// in later examples.

		if(clazz != null){
			ObjectContainer db = Db4o.openFile(AllSamples.FILE);
			System.out.println("*** Retrieving all objects of class " + clazz.getName() );
			try{
				ObjectSet os = db.get(clazz.newInstance());
				while(os.hasNext()){
					com.db4o.tools.Logger.log(db, os.next());
				}
			}catch(Exception e){
			}
			db.close();
		}
	}
}
