package com.db4o.samples;

import com.db4o.*;

public class S03_Get_All
{
	public static void main(String[] args)
	{
		Db4o.configure().messageLevel(-1);
		
		ObjectContainer db = Db4o.openFile(AllSamples.FILE);
		System.out.println("*** S03 Retrieving all objects");


		// a null parameter passed to db.get requests all stored objects
		ObjectSet os = db.get(null);

		
		// A db4o ObjectSet is quite similar to a JDK Collection Iterator.
		while(os.hasNext()){


			// the Logger provides a convenient way
			// to analyse the data of objects
			com.db4o.tools.Logger.log(db,os.next());
			

		}
		db.close();
	}
}

