package com.db4o.samples;

import com.db4o.*;

public class S02_Set_Complex
{
	public static void main(String[] args)
	{
		Db4o.configure().messageLevel(-1);
		
		ObjectContainer db = Db4o.openFile(AllSamples.FILE);
		Company company = new Company();
		company.name = "DreamFactory";
		company.addresses = new Address[2];
		company.addresses[0] = new Address();
		company.addresses[0].street = "San Antonio Drive";
		company.addresses[0].city = "Cloud Valley";
		company.addresses[1] = new Address();
		company.addresses[1].street = "Heaven 17";
		company.addresses[1].city = "Silicon Hills";

		// One call to set() stores all newly added members,
		// no matter how complex an object is.
		db.set(company);
		
		
		db.commit();


		System.out.println("*** S02 Company 'DreamFactory' and members were stored to samples.yap.");
		db.close();
	}
}
