package com.db4o.samples;

import com.db4o.*;

public class S01_Set
{
	public static void main(String[] args){
		Db4o.configure().messageLevel(-1);
		
		// We delete a possible old sample file here, so we know which objects
		// we can expect.
		new java.io.File(AllSamples.FILE).delete();


		// opens or creates the database file "samples.yap"
		ObjectContainer db = Db4o.openFile(AllSamples.FILE);


		// Create an object
		Individual alice = new Individual();
		alice.firstName = "Alice";
		alice.name = "Wonderland";


		// one simple call stores the object into the db4o database
		db.set(alice);


		// We need company for Alice, otherwise she gets bored.
		Individual peter = new Individual();
		peter.firstName = "Peter";
		peter.name = "Pan";
		db.set(peter);

		
		// the commit call makes the objects available for other connections
		// and flushes indices to the file.
		db.commit();
		
		
		System.out.println("*** S01 'Alice Wonderland' and 'Peter Pan' were stored to samples.yap.");
		
		// Make sure to call close() to shutdown the engine.
		db.close();
	}
}
