package com.db4o.lib;

import java.lang.reflect.*;
import java.io.*;

public class Platform{
	
	private static PrintStream ps;
	static private final int USE = 1;
	static private final int UNCHECKED = 0;
	static private final int DONT_USE = -1;
	static private int setAccessibleCheck;
	
	
	public static boolean isJDK2(){
		return canSetAccessible();
	}
	
	public static boolean canSetAccessible(){
		if (setAccessibleCheck == UNCHECKED) {
			if (methodIsAvailable("java.lang.reflect.AccessibleObject",
				"setAccessible",
				new Class[] { boolean.class })) {
				setAccessibleCheck = USE;
			} else {
				setAccessibleCheck = DONT_USE;
			}
		}
		return setAccessibleCheck == USE;
	}
	
	public static boolean isSimple(Class a_class){
		for (int i = 0; i < SIMPLE_CLASSES.length; i++) {
			if(a_class == SIMPLE_CLASSES[i]){
				return true;
			}
		}
		return false;
	}
	
	private static boolean methodIsAvailable(
		String className,
		String methodName,
		Class[] params) {
		try {
			Class clazz = Class.forName(className);
			if (clazz.getMethod(methodName, params) != null) {
				return true;
			}
		} catch (Error e) {
		} catch (Throwable t) {
		}
		return false;
	}
	
	
	public static void setAccessible(Object a_accessible) {
		if (setAccessibleCheck == UNCHECKED) {
			canSetAccessible();
		}
		if (setAccessibleCheck == USE) {
			JDK_1_2.setAccessible(a_accessible);
		}
	}
	

	public static boolean storeableField(Class a_class, Field a_field){
		if(Modifier.isStatic(a_field.getModifiers())){
			return false;
		}
		if(canSetAccessible()){
			if(Modifier.isTransient(a_field.getModifiers())){
				return false;
			}
		}else{
		    if(Modifier.isTransient(a_field.getModifiers())){
				return false;
			}
			if (! Modifier.isPublic(a_field.getModifiers())){
				return false;
			}
		}
		return true;
	}
	
	public static PrintStream outputFile(){
		if(ps == null){
			try{
				ps = new PrintStream(new FileOutputStream("out.txt"));
			}catch(Exception e){
			}
		}
		return ps;
	}
	
	public static void outputToFile(){
		outputFile();
		System.setOut(ps);
		System.setErr(ps);
	}
	
	private static final Class[] SIMPLE_CLASSES ={
		Integer.class,
		Long.class,
		Float.class,
		Boolean.class,
		Double.class,
		Byte.class,
		Character.class,
		Short.class,
		String.class,
		java.util.Date.class
	};

}