package  com.db4o.lib;

/**
 * linked list Collection implementation
 * There is one difference to be noted to the JDK Collections:
 * toArray(Object[])
 * the passed array has to be initialized to the right length
 */
public class List4 {
    private ListElement i_first;		// First element of the linked list
    private int i_size = 0;		// Number of elements collected
    
	
    public final void add (Object a_object) {
        i_first = new ListElement(i_first,a_object);
        i_size++;
    }

    public void add (Object[] a_objects) {
        if (a_objects != null) {
            for (int i = 0; i < a_objects.length; i++) {
                add(a_objects[i]);
            }
        }
    }

    public void addAll (List4 a_Collection) {
        addAll(a_Collection.iterator());
    }

    public void addAll (Iterator4 a_Iterator) {
        a_Iterator.reset();
        while (a_Iterator.hasNext()) {
            add(a_Iterator.next());
        }
    }

	public void clear () {
        i_first = null;
        i_size = 0;
    }

    /**
     * deep clone
     */
    public Object clone () {
        List4 collection = new List4();
        collection.i_size = i_size;
        if (i_first != null) {
            collection.i_first = ((ListElement)i_first)._clone();
        }
        return  collection;
    }
    
	public final boolean containsByIdentity(Object a_obj) {
		ListElement current = i_first;
		while (current != null) {
			if (current.i_object != null && current.i_object == a_obj) {
				return true;
			}
			current = current.i_next;
		}
		return false;
	}

    public boolean contains (Object a_Object) {
        Iterator4 i = iterator();
        while (i.hasNext()) {
			if (a_Object.equals(i.next())){
				return true;
			}
        }
        return  false;
    }

    public boolean containsAll (List4 a_collection) {
        Iterator4 i = a_collection.iterator();
        while (i.hasNext()) {
            if (!(contains(i.next()))) {
                return  false;
            }
        }
        return  true;
    }

    Object getFirst () {
        return  i_first;
    }

    public boolean isEmpty () {
        return  !(size() > 0);
    }

    public Iterator4 iterator () {
		return new Iterator4(this, i_first);
    }

    public void remove (Object a_Equals) {
        Iterator4 i = iterator();
        while (i.hasNext()) {
			if (a_Equals.equals(i.next())){
				i.remove();
			}
        }
    }

    void setFirst (ListElement a_object) {
        i_first = a_object;
    }

    public int size () {
        return  i_size;
    }

    void sizeDecrement () {
        i_size--;
    }

    public Object[] toArray () {
        // Backwards, because elements are added backwards
        int j = (int)i_size;
        Object[] l_Objects = new Object[j];
        Iterator4 i = iterator();
        while (i.hasNext()) {
            l_Objects[--j] = i.next();
        }
        return  l_Objects;
    }

    /**
	 * Copies all objects in the collection to the passed array and returns it.
	 * There is a difference to JDK 1.2 Collection here.
	 * To avoid the necessity for reflection, the passed array has to be created to
	 * the size of the collection.
     */
    public Object[] toArray (Object[] a_array) {
        // this is the non reflection version, in contrast to suns implementation
        // the passed array has to be initialized to the right length
        int j = (int)i_size;
        Iterator4 i = iterator();
        while (i.hasNext()) {
            a_array[--j] = i.next();
        }
        return  a_array;
    }
}

