package com.db4o.bench;
import java.sql.*;

public class IDsAndPkeysSQL extends IDsAndPkeys {

	public void run(Connection con) throws Exception {
		setUp(con);
		fill(false, con);
		timeSQL(con);
	}

	static void setUp(Connection c) throws Exception {
		Statement s = c.createStatement();
		try {
			s.executeUpdate("DROP TABLE BenchContest");
		} catch (Exception e) {
		}
		s.executeUpdate(
			"CREATE TABLE BenchContest (pkey INTEGER, strL VARCHAR(100), strS VARCHAR(30), dbl DOUBLE)");
		try {
			// might not work on all databases
			s.executeUpdate("CREATE UNIQUE INDEX pkeyIndex ON BenchContest (pkey)");
		} catch (Exception e) {
		}
		c.commit();
	}

	static void timeSQL(Connection c) throws Exception {
		Statement s = c.createStatement();
		ResultSet rs;
		String sql = "select * from BenchContest WHERE pkey = ";
		IDsAndPkeys res;
		startInstantiate();
		for (int i = 0; i < RUNS; i++) {
			rs = s.executeQuery(sql + i);
			rs.next();
			res = new IDsAndPkeys();
			res.pkey = rs.getInt("pkey");
			res.strL = rs.getString("strL");
			res.strS = rs.getString("strS");
			res.dbl = rs.getDouble("dbl");
		}
		BenchMark.stop();
	}
}