package com.db4o.bench;
import  java.sql.*;
import  java.io.*;
import com.db4o.*;

public class IDsAndPkeys
{
    static transient int    ROWCOUNT = 3000;
    static transient int    RUNS = 100;

    public int    pkey;
    public String   strL;
    public String   strS;
    public double   dbl;

    static PrintStream  out = System.out;


    public static void run ()
    {
    	BenchMark.tagDb4o();
		BenchMark.deleteOldFiles();
		fill(true, null);
        timeDb4o();
    }


    static void fill(boolean isDb4o, Connection c)
    {
    	try{
	    	ObjectContainer con = null;
	        Statement s = null;
	
	        if(isDb4o)
	        {
	            con = BenchMark.openFile();
	        }
	        else
	        {
	            s = c.createStatement();
	        }
	        startInsert();
	        String sql = "INSERT INTO BenchContest(pkey, strL, strS, dbl) VALUES ";
	        for (int i = 0; i < ROWCOUNT; i++)
	        {
	            IDsAndPkeys n = new IDsAndPkeys();
	            n.pkey = i;
	            n.strL = "fhskdj fhkjsdh fkjsdhf skjhf skljhf jkshfjksdf hskhfksj hfjksdh jklsdhfskjhfksjdhfsdjklfhlksjdhfjklsd";
	            n.strS = "grin";
	            n.dbl = 42.42;
	            if(isDb4o)
	            {
	                con.set(n);
	            }
	            else
	            {
	                s.executeUpdate(sql + "(" + i + ",'" + n.strL + "','" + n.strS + "'," + n.dbl + ")");
	            }
	        }
	
	        if(isDb4o)
	        {
	            con.close();
	        }
	        else
	        {
	            c.commit();
	        }
	        BenchMark.stop();
    	}catch(Exception e){
    		e.printStackTrace();
    	}

    }

    static void timeDb4o()
    {
        // This run is necessary to get the internal IDs that
        // are needed for the lookup. They would typically be
        // carried along in the Servlet session.
        ObjectContainer con = BenchMark.openFile();
        long[] ids = new long[RUNS];
        int i=0;
        ObjectSet set = con.get(new IDsAndPkeys());
        while(set.hasNext())
        {
            ids[i++] = con.ext().getID(set.next());
            if(i >= RUNS)
            {
                break;
            }
        }
        con.close();

        
        con = BenchMark.openFile();
        IDsAndPkeys res;
        startInstantiate();
        for(i = 0; i < RUNS; i++)
        {
            res = (IDsAndPkeys)con.ext().getByID(ids[i]);
            con.activate(res,1);
        }
        BenchMark.stop();
        con.close();
    }
    
  	static void startInsert(){
		BenchMark.start("" + ROWCOUNT + " objects stored for ID retrieval");
	}

	static void startInstantiate(){
		BenchMark.start("" + RUNS + " instantiations of " + ROWCOUNT + " objects by ID");
	}
    
    
}