package com.db4o.bench;

import com.db4o.*;
import java.sql.*;

public class BenchUpdate
{
	private static int updateRuns = 10;
	private static String tag = updateRuns + " updates on " + BenchMark.runs;
	private static String intTag = tag + " int";
	private static String stringTag = tag + " string";
	
	private static String stringData = "Benchmarked";
	
	public static void db4oInt(ObjectContainer db){
		BenchInt intUpdate;
		BenchMark.start(intTag);
		for (int i = 0; i < updateRuns; i++) {
			ObjectSet set = db.get(new BenchInt());
			while(set.hasNext()){
				intUpdate = (BenchInt)set.next();
				intUpdate.i_int ++;
				db.set(intUpdate);
			}
		}
		db.commit();
		BenchMark.stop();
	}
	
	public static void db4oString(ObjectContainer db){
		BenchString stringUpdate;
		BenchMark.start(stringTag);
		for (int i = 0; i < updateRuns; i++) {
			ObjectSet set = db.get(new BenchString());
			while(set.hasNext()){
				stringUpdate = (BenchString)set.next();
				stringUpdate.i_string = stringData;
				db.set(stringUpdate);
			}
		}
		db.commit();
		BenchMark.stop();
	}
	
	public static void sqlInt(Connection c, Statement s) throws SQLException{
		String sql = "update " + BenchSql.tableInt + " set " + BenchSql.fieldInt 
					 + " = " + BenchSql.fieldInt + " + 1";
		BenchMark.start(intTag);
		for (int i = 0; i < updateRuns; i++) {
			s.executeUpdate(sql);
		}
		c.commit();
		BenchMark.stop();
	}
	
	public static void sqlString(Connection c, Statement s) throws SQLException{
		String sql = "update " + BenchSql.tableString + " set " + BenchSql.fieldString 
					 + " = '" + stringData + "'";
		BenchMark.start(stringTag);
		for (int i = 0; i < updateRuns; i++) {
			s.executeUpdate(sql);
		}
		c.commit();
		BenchMark.stop();
	}


	
	
	
}
