package com.db4o.bench;

import java.sql.*;
import com.db4o.sql.*;

/**
 * @only JAVA
 */
public class BenchSql
{
	public static String tableInt = "db4o_Bench_Int";
	public static String tableString = "db4o_Bench_String";
	public static String fieldInt = "db4o_Int";
	public static String fieldString = "db4o_String";
	
	static void prepareTables(Connection c) throws SQLException{
		Statement s = Sql.createStatement(c);
		execute(s, "drop table " + tableString);
		execute(s, "drop table " + tableInt);
		execute(s, "create table " + tableInt + "(" + fieldInt + " Integer)");
		String strLen = "" + (BenchInsert.stringData.length() + 10);
		execute(s, "create table " + tableString + "(" + fieldString + " VARCHAR(" + strLen + "))");
		c.commit();
	}
	
	static void execute(Statement s, String sql){
		try{
			s.execute(sql);
		}
		catch(Exception e){
			// Logger.log("Failed: " + sql);
			return;	
		}
		// Logger.log("OK: " + sql);
	}
	
	
}

