package com.db4o.bench;

import com.db4o.*;
import java.sql.*;

public class BenchSelect
{
	private static int scanRuns = 50;
	private static String tag = "" + scanRuns +  " scans on " + BenchMark.runs;
	private static String intTag = tag + " int";
	private static String stringTag = tag + " string";
	
	public static int db4oInt(ObjectContainer db){
		BenchInt intIn0 = new BenchInt();
		BenchInt intIn1 = new BenchInt();
		BenchInt intIn2 = new BenchInt();
		BenchInt intOut = null;
		
		intIn0.i_int = 3; 
		intIn1.i_int = BenchMark.runs / 2;
		intIn2.i_int = BenchMark.runs - 3; 
		
		BenchMark.start(intTag);
		for (int i = 0; i < scanRuns; i ++){
			intOut = (BenchInt)db.get(intIn0).next();
			intOut = (BenchInt)db.get(intIn2).next();
			intOut = (BenchInt)db.get(intIn1).next();
		}
		BenchMark.stop();
		if(intOut != null){
			return intOut.i_int;
		}
		return -1;
	}
	
	public static String db4oString(ObjectContainer db){
		BenchString stringIn0 = new BenchString();
		BenchString stringIn1 = new BenchString();
		BenchString stringIn2 = new BenchString();
		stringIn0.i_string = BenchInsert.stringData +  3;
		stringIn0.i_string = BenchInsert.stringData +  (BenchMark.runs / 2);
		stringIn0.i_string = BenchInsert.stringData +  (BenchMark.runs - 3);
		BenchString stringOut = null;
		
		BenchMark.start(stringTag);
		for (int i = 0; i < scanRuns; i ++){
			stringOut = (BenchString)db.get(stringIn0).next();
			stringOut = (BenchString)db.get(stringIn2).next();
			stringOut = (BenchString)db.get(stringIn1).next();
		}
		BenchMark.stop();
		if(stringOut != null){
			return stringOut.i_string;
		}
		return "Not found";
	}
	
	/**
	 * @only JAVA
	 */
	public static int SqlInt(Statement s) throws SQLException{
		int intOut= 0;
		String sql0 = "select * from " + BenchSql.tableInt + " where " 
					 + BenchSql.fieldInt + " = " + 3;
		String sql1 = "select * from " + BenchSql.tableInt + " where " 
					 + BenchSql.fieldInt + " = " + (BenchMark.runs / 2);
		String sql2 = "select * from " + BenchSql.tableInt + " where " 
					 + BenchSql.fieldInt + " = " + (BenchMark.runs - 3);
		ResultSet rs = null;
		BenchMark.start(intTag);
		for (int i = 0; i < scanRuns; i ++){
			rs = s.executeQuery(sql0);
			rs.next();
			intOut = rs.getInt(1);
			rs = s.executeQuery(sql2);
			rs.next();
			intOut = rs.getInt(1);
			rs = s.executeQuery(sql1);
			rs.next();
			intOut = rs.getInt(1);
		}
		BenchMark.stop();
		return intOut;
	}
	
	/**
	 * @only JAVA
	 */
	public static String SqlString(Statement s) throws SQLException{
		String stringOut = null;
		String sql0 = "select * from " + BenchSql.tableString + " where " 
					 + BenchSql.fieldString + " = '" + BenchInsert.stringData + 3 + "'";
		String sql1 = "select * from " + BenchSql.tableString + " where " 
					 + BenchSql.fieldString + " = '" + BenchInsert.stringData + (BenchMark.runs / 2) + "'";
		String sql2 = "select * from " + BenchSql.tableString + " where " 
					 + BenchSql.fieldString + " = '" + BenchInsert.stringData + (BenchMark.runs - 3) + "'";
		ResultSet rs = null;
		BenchMark.start(stringTag);
		for (int i = 0; i < scanRuns; i ++){
			rs = s.executeQuery(sql0);
			rs.next();
			stringOut = rs.getString(BenchSql.fieldString);
			rs = s.executeQuery(sql2);
			rs.next();
			stringOut = rs.getString(BenchSql.fieldString);
			rs = s.executeQuery(sql1);
			rs.next();
			stringOut = rs.getString(BenchSql.fieldString);
		}
		BenchMark.stop();
		return stringOut;
	}



	
}
