package com.db4o.bench;

import com.db4o.*;
import java.sql.*;

public class BenchRetrieve
{
	private static String intTag = "" + BenchMark.runs + " int retrieval";
	private static String stringTag = "" + BenchMark.runs + " String retrieval";
	
	public static void db4oInt(ObjectContainer db){
		BenchInt intOut;
		BenchMark.start(intTag);
		ObjectSet set = db.get(new BenchInt());
		while (set.hasNext()){
			intOut = (BenchInt)set.next();
		}
		BenchMark.stop();
	}
	
	public static void db4oString(ObjectContainer db){
		BenchString stringOut;
		BenchMark.start(stringTag);
		ObjectSet set = db.get(new BenchString());
		while (set.hasNext()){
			stringOut = (BenchString)set.next();
		}
		BenchMark.stop();
	}
	
	/**
	 * @only JAVA
	 */
	public static void sqlInt(Statement s) throws SQLException{
		int intOut;
		String sql = "select " + BenchSql.fieldInt + " from " + BenchSql.tableInt;
		BenchMark.start(intTag);
		ResultSet rs = s.executeQuery(sql);
		while(rs.next()){
			intOut = rs.getInt(1);
		}
		BenchMark.stop();
	}
	
	/**
	 * @only JAVA
	 */
	public static void sqlString(Statement s)throws SQLException{
		String stringOut;
		String sql = "select " + BenchSql.fieldString + " from " + BenchSql.tableString;
		BenchMark.start(intTag);
		ResultSet rs = s.executeQuery(sql);
		while(rs.next()){
			stringOut = rs.getString(1);
		}
		BenchMark.stop();
	}
	
}
