package com.db4o.bench;

import java.sql.*;
import com.db4o.sql.*; // library comes with db4o download

public class BenchMarkSQL extends BenchMark {
	public BenchMarkSQL() {
		tagSQL();

		if (JDBC_Driver.length() > 0 && JDBC_ConnectString.length() > 0) {
			try {
				Connection c =
					Sql.connect(
						new SqlConfiguration(
							JDBC_Driver,
							JDBC_ConnectString,
							JDBC_User,
							JDBC_Password));
				if (c != null) {
					c.setAutoCommit(false); // we use explicit commit where appropriate

					new IDsAndPkeysSQL().run(c);

					try {
						BenchComplex bc =
							(BenchComplex) Class.forName("com.db4o.bench.BenchComplexSQL").newInstance();
						bc.run(c);
					} catch (Exception e) {
					}

					if (!skipBench) {

						Statement s = Sql.createStatement(c);
						BenchSql.prepareTables(c);
						BenchInsert.sqlInt(s);
						c.commit();
						BenchSelect.SqlInt(s);
						// BenchRetrieve.sqlInt(s);
						BenchUpdate.sqlInt(c, s);
						c.commit();
						BenchInsert.sqlString(s);
						c.commit();
						BenchSelect.SqlString(s);
						// BenchRetrieve.sqlString(s);
						BenchUpdate.sqlString(c, s);
						c.commit();
					}
				}

			} catch (Exception e) {
				print("The JDBC Benchmark run threw an exception.");
				print("Exception class:" + e.getClass().getName());
				print("Message: " + e.getMessage());
			}
		} else {
			print(
				"Edit JDBC_Driver and JDBC_ConnectString in \ncom.db4o.Benchmark.java for JDBC results. ");
		}
	}
}