package  com.db4o.bench;

import com.db4o.*;
import com.db4o.ext.*;
import com.db4o.lib.*;

public class BenchMark {
	
	// Edit the following JDBC connection settings to test db4o
	// against the SQL database of your choice.
	
	protected static String 		JDBC_Driver = "";
	protected static String 		JDBC_ConnectString = "";
	protected static String			JDBC_User="";
	protected static String			JDBC_Password="";

    // For different test setups
    public static int				runs = 1000;
    private static final boolean	USE_MEMORY_FILE = false;
    
    private static final boolean	USE_SERVER = false;
    private static final boolean	USE_IN_PROCESS_SERVER = false;
    
    private static final String 	SERVER_HOST_NAME = "localhost";
	private static final int 		SERVER_PORT = 4445;
    private static ObjectServer 	server;
    
    private static final String		DB4O_FILE = "bench.yap";
    
    private static MemoryFile		memoryFile;
    private static String			runningTag;
    private static String			tag;
    
   	protected static final boolean	skipBench = false;

    public static void main (String[] args) {
    	
    	Db4o.configure().messageLevel(-1);
    	
        if (args != null) {
            if (args.length > 0) {
                runs = new Integer(args[0]).intValue();
            }
			if(args.length  > 2){
				JDBC_Driver = args[1];
				JDBC_ConnectString = args[2];
			}
        }
		try{
			Class.forName("com.db4o.bench.BenchMarkSQL").newInstance();

		}catch(Exception e){}
		
		deleteOldFiles();
		
		if(USE_SERVER && USE_IN_PROCESS_SERVER){
			server = Db4o.openServer(DB4O_FILE, SERVER_PORT);
			server.grantAccess("db4o", "db4o");
		}

		System.out.println("");
		String tag = "Overall db4o performance";
		Timer.start(tag);


		new IDsAndPkeys().run();
		new BenchComplex().run(null);

		if(skipBench){
			return;
		}
		
		ObjectContainer db;
        tagDb4o();

        db = openFile();
        BenchInsert.db4oInt(db);
        db.close();

		db = openFile();  // reopening the data file produces cold results
        BenchSelect.db4oInt(db);
        db.close();

        /*
		db = openFile();
        BenchRetrieve.db4oInt(db);
        db.close();
		*/

        db = openFile();
        BenchUpdate.db4oInt(db);
        db.close();

        db = openFile();
        BenchInsert.db4oString(db);
        db.close();

        db = openFile();
        BenchSelect.db4oString(db);
        db.close();

		/*
        db = openFile();
        BenchRetrieve.db4oString(db);
        db.close();
		*/

        db = openFile();
        BenchUpdate.db4oString(db);
        db.close();

		print("");
		Timer.stop(tag);

		// upDown();
		
		
		if(USE_SERVER && USE_IN_PROCESS_SERVER){
			server.close();
		}

		print("\nVersion: " + Db4o.version());

        print("\nMail results to bench@db4o.com to make us happy.");
        print("Please include information about your environment.\n");
    }
    
    static void deleteOldFiles(){
        new java.io.File(DB4O_FILE).delete(); // a clean file ensures no duplicates
        memoryFile = new MemoryFile(); // for consecutive memoryfile runs in one VM
    }
    
    static ObjectContainer openFile(){
    	if(USE_SERVER){
    		try {
			    return Db4o.openClient(SERVER_HOST_NAME,SERVER_PORT,"db4o","db4o");		
			} catch (Exception e) {
				System.out.println("Connection to server failed.");
				System.out.println("Check if the server ist started and host and portname are corrct.");
			}
			return null;
    	}
	    if(USE_MEMORY_FILE){
		   	return ExtDb4o.openMemoryFile(memoryFile);	
	    }else{
		   	 return Db4o.openFile(DB4O_FILE);
	    }
    }

	static void upDown(){
		int upRuns = runs / 500;
		String tag = "" + upRuns + " Ups and Downs";
        Timer.start(tag);
		ObjectContainer db;
		for(int i = 0; i < upRuns; i++){
			db = Db4o.openFile(DB4O_FILE );
			db.close();
		}
		Timer.stop(tag);
	}

    static void start (String starttag) {
        tag = runningTag + starttag;
        Timer.start(tag);
    }

    static void stop () {
        Timer.stop(tag);
    }

	static void tagDb4o(){
		runningTag = "db4o - ";
	}

	static void tagSQL(){
		runningTag = "SQL - ";
	}
	
	static void print(String msg){
		System.out.println(msg);
	}

}

