package com.db4o.bench;

import com.db4o.*;
import java.sql.*;

/**
 * use the File BenchMark.java / BenchMark.cs
 */
public class BenchInsert
{
	private static String intTag = "" + BenchMark.runs + " int inserts";
	private static String stringTag = "" + BenchMark.runs + " String inserts";
	
	public static String stringData = "This sentence no verb.";

	public static void db4oInt(ObjectContainer db){
		BenchMark.start(intTag);
		BenchInt intIn;
		for (int i = BenchMark.runs; i > 0; i--){
			intIn = new BenchInt();
			intIn.i_int = i;
			db.set(intIn);
		}
		BenchMark.stop();
	}
	
	public static void db4oString(ObjectContainer db){
		BenchString stringIn;
		BenchMark.start(stringTag);
		for (int i = BenchMark.runs; i > 0; i--){
			stringIn = new BenchString();
			stringIn.i_string = stringData + i;
			db.set(stringIn);
		}
		BenchMark.stop();
	}
	
	/**
	 * @only JAVA
	 */
	public static void sqlInt(Statement s) throws SQLException{
		BenchMark.start(intTag);
		String sql = "insert into " + BenchSql.tableInt + " (" 
					 + BenchSql.fieldInt + ") values (";
		for (int i = BenchMark.runs; i > 0; i--){
			s.execute(sql + i + ")");
		}
		BenchMark.stop();
	}
	
	/**
	 * @only JAVA
	 */
	public static void sqlString(Statement s)throws SQLException{
		BenchMark.start(stringTag);
		String sql = "insert into " + BenchSql.tableString + " (" 
					+ BenchSql.fieldString + ") values ('"
					+ stringData;
		for (int i = BenchMark.runs; i > 0; i--){
			s.execute(sql + i + "')");
		}
		BenchMark.stop();
	}

	
	
	
}
