package com.db4o.bench;

import com.db4o.*;


public class BenchComplex
{
	protected static boolean	skipBench = false;
	public static int			runs = 100;

	public void run(Object con){

		if(skipBench){
			return;
		}
		
        BenchMark.deleteOldFiles();

		Contract contract; // for insert

		Contract example = new Contract(); // for Query By Example
			example.contractNo = "BIGCC";
			example.customer = new Customer();
			example.customer.customerNo = "ESS";
		
		ObjectContainer container = BenchMark.openFile();

		BenchMark.tagDb4o();
		startInsert();
		for (int i = 0; i < runs; i ++){
			contract = new Contract(
				new Customer("ESS", "Enterprise Systems Solutions")
				,"BIGCC","Cooperation Contract");
			db4oInsert(contract, container);
		}
		BenchMark.stop();

		startSelect();
		for (int i = 0; i < runs; i ++){
			db4oSelect(container, example);
		}
		BenchMark.stop();

		container.close();
	}

	Contract[] db4oSelect(ObjectContainer db4o, Contract example){
		ObjectSet set = db4o.get(example);
		
		Contract[] contracts = new Contract[set.size()];
		int i = 0;
		while(set.hasNext()){
			contracts[i ++] = (Contract)set.next();
		}
		return contracts;
	}

	void db4oInsert(Contract contract, ObjectContainer db4o){
		db4o.set(contract);
	}

	void startInsert(){
		BenchMark.start("" + runs + " complex inserts");
	}

	void startSelect(){
		BenchMark.start("" + runs + " complex selects");
	}

}


