/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.text.Keymap;

public class Installer
extends JFrame
implements ActionListener {
    private static final String libDir = "lib";
    private static final String syslibs = "syslibs.properties";
    private static final String standardClasses = "classes.zip";
    private static final String nl = System.getProperty("line.separator");
    private static final char slash = File.separatorChar;
    private static final String colon = File.pathSeparator;
    private static String jdkFile = "/lib/tools.jar";
    static final int BUFFER_SIZE = 8192;
    Color backgroundColour;
    Color textColour;
    JTextField directoryField;
    JTextField javaField;
    JLabel textLabel1;
    JLabel textLabel2;
    JButton browseDirButton;
    JButton browseJdkButton;
    JRadioButton jdk12Button;
    JRadioButton jdk13Button;
    JButton installButton;
    JButton cancelButton;
    JProgressBar progress;
    int progressPercent = 0;
    Timer timer;
    String currentDirectory = System.getProperty("user.dir");
    String osname;
    String architecture;
    String javaVersion;
    boolean isJDK12;
    String installationDir = this.currentDirectory.endsWith("bluej") ? this.currentDirectory : String.valueOf(this.currentDirectory) + File.separator + "bluej";
    String javaPath = "";
    Hashtable properties;
    long myTotalBytes;

    static {
        JTextField jTextField = new JTextField();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = jTextField.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
    }

    public Installer() {
        this.osname = System.getProperty("os.name");
        this.architecture = System.getProperty("os.arch");
        this.javaVersion = System.getProperty("java.version");
        this.isJDK12 = this.javaVersion.startsWith("1.2");
        this.javaPath = this.findJavaPath();
        this.unpackTo(false);
        this.makeWindow();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.browseDirButton) {
            this.getInstallDirectory();
        } else if (object == this.browseJdkButton) {
            this.getJDKDirectory();
        } else if (object == this.installButton) {
            InstallThread installThread = new InstallThread();
            installThread.setPriority(2);
            installThread.start();
            this.timer.start();
        } else if (object == this.cancelButton) {
            this.doCancel();
        }
    }

    private static void buildInstaller(String string) {
        try {
            int n;
            Hashtable hashtable = Installer.loadProperties(string);
            RandomAccessFile randomAccessFile = new RandomAccessFile("Installer.class", "rw");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream((String)hashtable.get("pkgJar")));
            long l = 0L;
            byte[] byArray = new byte[8192];
            randomAccessFile.seek(randomAccessFile.length());
            System.err.println("Original file is " + randomAccessFile.length());
            long l2 = randomAccessFile.length();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(randomAccessFile.getFD()));
            if (objectOutputStream == null) {
                System.err.println("Could not open output file");
            }
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.flush();
            while ((n = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                randomAccessFile.write(byArray, 0, n);
                l += (long)n;
            }
            System.err.println("Jar is " + l + " bytes.");
            l = randomAccessFile.length() - l2;
            System.err.println("Added a total of " + l + " bytes.");
            System.err.println("New size is " + randomAccessFile.length());
            randomAccessFile.writeLong(l);
            randomAccessFile.close();
            bufferedInputStream.close();
            System.err.println("Done.");
        }
        catch (IOException iOException) {
            System.err.println("Couldn't build installer: " + iOException.getMessage());
            System.exit(1);
        }
    }

    private boolean checkInstallDir(String string, boolean bl) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            this.notifyProblem("The name you specified exists\nand is not a directory. Cannot\ninstall there.");
            return false;
        }
        File file2 = file.getParentFile();
        if (file2.exists()) {
            if (file2.isDirectory()) {
                if (bl) {
                    file.mkdir();
                }
                return true;
            }
            this.notifyProblem(String.valueOf(file2.getAbsolutePath()) + " is not\n" + "a directory. Cannot install there.");
            return false;
        }
        this.notifyProblem("The directory " + file2.getAbsolutePath() + "\ndoes not exist.\n" + "Please check the path and enter again.");
        return false;
    }

    private void doCancel() {
        System.exit(0);
    }

    public void doInstall() {
        this.readInputValues();
        if (!this.isJDKPath(this.javaPath)) {
            this.jdkPathProblem();
            return;
        }
        try {
            if (!this.checkInstallDir(this.installationDir, true)) {
                return;
            }
            this.unpackTo(true);
            if (this.getProperty("exeName") != null) {
                if (this.osname == null) {
                    this.writeWindows();
                    this.writeUnix();
                } else if (this.osname.startsWith("Windows")) {
                    if (this.isJDK12) {
                        this.writeWindows12();
                    } else {
                        this.writeWindows();
                    }
                } else if (!this.isJDK12) {
                    this.writeUnix();
                } else if (this.osname.startsWith("Linux")) {
                    this.writeUnix12(false);
                } else {
                    this.writeUnix12(true);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.finish("Installation FAILED: ", exception.getMessage());
            return;
        }
        if (this.getProperty("exeName") != null) {
            this.finish("BlueJ has been installed to " + this.installationDir, "To run it, execute \"" + (String)this.getProperty("exeName") + "\".");
        } else {
            this.finish("The package has been installed to " + this.installationDir, " ");
        }
    }

    public void dumpJar(String string, FileInputStream fileInputStream) throws IOException, ZipException {
        ZipEntry zipEntry;
        this.makeDirsFor(string, "");
        long l = 0L;
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        byte[] byArray = new byte[8192];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            Object object;
            String string2 = String.valueOf(string) + "/" + zipEntry.getName();
            if (zipEntry.isDirectory()) {
                object = new File(string2);
                ((File)object).mkdirs();
                continue;
            }
            if (zipEntry.getName().indexOf(47) != -1) {
                this.makeDirsFor(string, zipEntry.getName());
            }
            try {
                object = new FileOutputStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException("Couldn't write to specified file/directory");
            }
            this.setStatus("extracting: " + string2);
            while ((n = zipInputStream.read(byArray, 0, 8192)) != -1) {
                l += (long)n;
                ((FileOutputStream)object).write(byArray, 0, n);
            }
            this.progressPercent = (int)(l * 100L / this.myTotalBytes / 4L);
            zipInputStream.closeEntry();
            ((FileOutputStream)object).close();
        }
        zipInputStream.close();
        this.timer.stop();
        this.progress.setValue(100);
    }

    private String findJavaPath() {
        String string = System.getProperty("java.home");
        if (this.isJDKPath(string)) {
            return string;
        }
        if (string.endsWith("jre") && this.isJDKPath(string = string.substring(0, string.length() - 4))) {
            return string;
        }
        String string2 = this.javaVersion.substring(0, this.javaVersion.length() - 2);
        String[] stringArray = new String[]{"C:\\jdk" + this.javaVersion, "C:\\jdk" + string2, "D:\\jdk" + this.javaVersion, "D:\\jdk" + string2, "/usr/java", "/usr/local/java", "/usr/jdk" + this.javaVersion, "/usr/jdk" + string2, "/usr/local/jdk" + this.javaVersion, "/usr/local/jdk" + string2};
        int n = 0;
        while (n < stringArray.length) {
            if (this.isJDKPath(stringArray[n])) {
                return stringArray[n];
            }
            ++n;
        }
        return "";
    }

    public void finish(String string, String string2) {
        this.textLabel1.setText(string);
        this.textLabel2.setText(string2);
        this.installButton.setEnabled(false);
        this.cancelButton.setText("Done");
        this.getRootPane().setDefaultButton(this.cancelButton);
    }

    public String getDirName(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, "Choose");
        if (n == 0) {
            return jFileChooser.getSelectedFile().getPath();
        }
        return null;
    }

    private void getInstallDirectory() {
        String string = this.getDirName("Select installation directory");
        if (string != null) {
            this.installationDir = string.endsWith("bluej") ? string : String.valueOf(string) + File.separator + "bluej";
            this.directoryField.setText(this.installationDir);
            this.checkInstallDir(this.installationDir, false);
        }
    }

    private void getJDKDirectory() {
        String string = this.getDirName("Select JDK directory");
        if (string != null) {
            this.javaPath = string;
            this.javaField.setText(this.javaPath);
            if (!this.isJDKPath(this.javaPath)) {
                this.jdkPathProblem();
            }
        }
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public boolean isJDKPath(String string) {
        String string2 = String.valueOf(string) + jdkFile;
        return new File(string2).exists();
    }

    private void jdkPathProblem() {
        this.notifyProblem("The Java directory you have specified is not a valid \nJDK directory. The JDK directory is the directory \nthat JDK (aka Java 2 SDK) was installed to. It must \nhave a subdirectory \"lib\" with a file named \n\"tools.jar\" in it.");
    }

    public static Hashtable loadProperties(String string) {
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Properties properties = new Properties();
        try {
            object = new FileInputStream(string);
            properties.load((InputStream)object);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.getMessage());
        }
        object = "color.";
        String string2 = "gif.";
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            Object object2;
            String string3 = (String)enumeration.nextElement();
            Object object3 = properties.getProperty(string3);
            if ((string3 = string3.substring(string3.indexOf(46) + 1)).regionMatches(0, (String)object, 0, ((String)object).length())) {
                object2 = new StringTokenizer((String)object3, " \t,", false);
                int n = Integer.valueOf(((StringTokenizer)object2).nextToken());
                int n2 = Integer.valueOf(((StringTokenizer)object2).nextToken());
                int n3 = Integer.valueOf(((StringTokenizer)object2).nextToken());
                object3 = new Color(n, n2, n3);
            } else if (string3.regionMatches(0, string2, 0, string2.length())) {
                object3 = object2 = (Object)Installer.readGIF((String)object3);
            }
            hashtable.put(string3, (String)object3);
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("build")) {
                Installer.buildInstaller(stringArray[1]);
            } else {
                System.out.println("unknown argument: " + stringArray[0]);
            }
            System.exit(0);
        } else {
            new Installer();
        }
    }

    public void makeDirsFor(String string, String string2) {
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/", false);
        string3 = string;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            File file = new File(String.valueOf(string3) + File.separatorChar + string4);
            string3 = file.toString();
            file.mkdirs();
        }
    }

    public void makeWindow() {
        this.backgroundColour = (Color)this.getProperty("color.background");
        this.textColour = (Color)this.getProperty("color.text");
        ((Component)this).setBackground(this.backgroundColour);
        String string = (String)this.getProperty("title");
        if (string != null) {
            this.setTitle(string);
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.setBackground(this.backgroundColour);
        Image image = this.getToolkit().createImage((byte[])this.getProperty("gif.logo"));
        JLabel jLabel = new JLabel(new ImageIcon(image));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.backgroundColour);
        this.installButton = new JButton("Install");
        jPanel2.add(this.installButton);
        this.installButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        jPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        jPanel.add((Component)jPanel2, "South");
        Box box = new Box(1);
        Box box2 = new Box(0);
        box2.add(Box.createHorizontalGlue());
        box2.add(new JLabel("Directory to install to:"));
        this.directoryField = new JTextField(this.installationDir, 16);
        box2.add(this.directoryField);
        this.browseDirButton = new JButton("Browse");
        this.browseDirButton.addActionListener(this);
        box2.add(this.browseDirButton);
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        Box box3 = new Box(0);
        box3.add(Box.createHorizontalGlue());
        box3.add(new JLabel("Java (JDK) directory:"));
        this.javaField = new JTextField(this.javaPath, 16);
        box3.add(this.javaField);
        this.browseJdkButton = new JButton("Browse");
        this.browseJdkButton.addActionListener(this);
        box3.add(this.browseJdkButton);
        box.add(box3);
        box.add(Box.createVerticalStrut(5));
        Box box4 = new Box(0);
        box4.add(new JLabel("JDK version:", 2));
        box4.add(Box.createHorizontalStrut(20));
        this.jdk12Button = new JRadioButton("jdk 1.2", this.isJDK12);
        this.jdk13Button = new JRadioButton("jdk 1.3", this.isJDK12 ^ true);
        this.jdk12Button.setBackground(this.backgroundColour);
        this.jdk13Button.setBackground(this.backgroundColour);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jdk12Button);
        buttonGroup.add(this.jdk13Button);
        box4.add(this.jdk12Button);
        box4.add(this.jdk13Button);
        box4.add(Box.createHorizontalGlue());
        box.add(box4);
        box.add(Box.createVerticalStrut(12));
        this.progress = new JProgressBar();
        box.add(this.progress);
        box.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        jPanel3.setBackground(this.backgroundColour);
        this.textLabel1 = new JLabel(" ", 2);
        jPanel3.add(this.textLabel1);
        this.textLabel2 = new JLabel(" ", 2);
        jPanel3.add(this.textLabel2);
        box.add(jPanel3);
        String string2 = (String)this.getProperty("tagline");
        if (string2 != null) {
            this.textLabel2.setText(string2);
        }
        jPanel.add((Component)box, "Center");
        this.getRootPane().setDefaultButton(this.installButton);
        this.pack();
        ((Component)this).setLocation(100, 100);
        ((Component)this).setVisible(true);
        this.timer = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Installer.this.progress.setValue(Installer.this.progressPercent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                Installer.this.installButton.requestFocus();
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public void notifyError(String string, String string2) {
        JOptionPane.showMessageDialog(this, string);
        this.finish(string2, "Installation aborted.");
    }

    private void notifyProblem(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public static byte[] readGIF(String string) {
        int n = (int)new File(string).length();
        byte[] byArray = new byte[n];
        System.err.println("Loading gif '" + string + "' (" + n + " bytes)");
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            fileInputStream.read(byArray, 0, n);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Couldn't load gif: " + iOException.getMessage());
        }
        return byArray;
    }

    private void readInputValues() {
        this.installationDir = this.directoryField.getText();
        this.javaPath = this.javaField.getText();
        this.isJDK12 = this.jdk12Button.isSelected();
    }

    String replace(String string, char c, String string2) {
        char[] cArray = new char[]{c};
        String string3 = new String(cArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.length() == 1 && string4.equals(string3)) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    public void setStatus(String string) {
        this.textLabel1.setText(string);
        this.textLabel1.repaint();
    }

    public void unpackTo(boolean bl) {
        try {
            int n;
            InputStream inputStream = ClassLoader.getSystemResourceAsStream("Installer.class");
            FileOutputStream fileOutputStream = new FileOutputStream("Installer.class.tmp");
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile("Installer.class.tmp", "r");
            randomAccessFile.seek(randomAccessFile.length() - 8L);
            long l = randomAccessFile.readLong();
            randomAccessFile.seek(randomAccessFile.length() - 8L - l);
            this.myTotalBytes = l;
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(randomAccessFile.getFD()));
            try {
                this.properties = (Hashtable)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException.getMessage());
            }
            if (bl) {
                this.dumpJar(this.installationDir, new FileInputStream(randomAccessFile.getFD()));
            }
            randomAccessFile.close();
            new File("Installer.class.tmp").delete();
        }
        catch (Exception exception) {
            this.notifyError("Installer failed to open: " + exception, "Could not open install file.");
        }
    }

    public void writeUnix() throws IOException {
        File file = new File(this.installationDir, (String)this.getProperty("exeName"));
        FileWriter fileWriter = new FileWriter(file.toString());
        fileWriter.write("#!/bin/sh\n");
        fileWriter.write("APPBASE=" + this.installationDir + "\n");
        String string = this.getProperty("unixCommands").toString();
        if (string != null) {
            string = this.replace(string, '~', "$APPBASE");
            string = this.replace(string, '!', this.javaPath);
            string = this.replace(string, '@', this.architecture);
            fileWriter.write(string);
            fileWriter.write("\n");
        }
        String string2 = this.getProperty("classpath").toString();
        string2 = string2.replace(';', ':');
        string2 = this.replace(string2, '~', "$APPBASE");
        string2 = this.replace(string2, '!', this.javaPath);
        string2 = this.replace(string2, '@', this.architecture);
        fileWriter.write("CLASSPATH=" + string2 + ":$CLASSPATH\n");
        fileWriter.write("export CLASSPATH\n");
        fileWriter.write(String.valueOf(this.javaPath) + "/bin/java " + this.getProperty("javaOpts") + " -D" + this.getProperty("installDirProp") + "=$APPBASE " + this.getProperty("mainClass") + " $*\n");
        fileWriter.close();
        try {
            Runtime.getRuntime().exec("chmod 755 " + file);
        }
        catch (Exception exception) {}
    }

    public void writeUnix12(boolean bl) throws IOException {
        File file = new File(this.installationDir, (String)this.getProperty("exeName"));
        FileWriter fileWriter = new FileWriter(file.toString());
        fileWriter.write("#!/bin/sh\n");
        fileWriter.write("APPBASE=" + this.installationDir + "\n");
        String string = bl ? this.getProperty("unixCommands.localJPDA").toString() : this.getProperty("unixCommands.systemJPDA").toString();
        if (string != null) {
            string = this.replace(string, '~', "$APPBASE");
            string = this.replace(string, '!', this.javaPath);
            string = this.replace(string, '@', this.architecture);
            fileWriter.write(string);
            fileWriter.write("\n");
        }
        String string2 = bl ? this.getProperty("classpath.localJPDA").toString() : this.getProperty("classpath.systemJPDA").toString();
        string2 = string2.replace(';', ':');
        string2 = this.replace(string2, '~', "$APPBASE");
        string2 = this.replace(string2, '!', this.javaPath);
        string2 = this.replace(string2, '@', this.architecture);
        fileWriter.write("CLASSPATH=" + string2 + ":$CLASSPATH\n");
        fileWriter.write("export CLASSPATH\n");
        fileWriter.write(String.valueOf(this.javaPath) + "/bin/java " + this.getProperty("javaOpts.1.2") + " -D" + this.getProperty("installDirProp") + "=$APPBASE " + this.getProperty("mainClass") + " $*\n");
        fileWriter.close();
        try {
            Runtime.getRuntime().exec("chmod 755 " + file);
        }
        catch (Exception exception) {}
    }

    public void writeWindows() throws IOException {
        File file = new File(this.installationDir, String.valueOf((String)this.getProperty("exeName")) + ".bat");
        FileWriter fileWriter = new FileWriter(file.toString());
        fileWriter.write("@echo off\r\n");
        fileWriter.write("set OLDPATH=%CLASSPATH%\r\n");
        fileWriter.write("set APPBASE=" + this.installationDir + "\r\n");
        String string = this.getProperty("winCommands").toString();
        if (string != null) {
            string = this.replace(string, '~', "%APPBASE%");
            string = this.replace(string, '!', this.javaPath);
            string = this.replace(string, '@', this.architecture);
            fileWriter.write(string);
            fileWriter.write("\r\n");
        }
        String string2 = this.getProperty("classpath").toString();
        string2 = string2.replace('/', '\\');
        string2 = this.replace(string2, '~', "%APPBASE%");
        string2 = this.replace(string2, '!', this.javaPath);
        string2 = this.replace(string2, '@', this.architecture);
        fileWriter.write("set CLASSPATH=" + string2 + ";%CLASSPATH%\r\n");
        fileWriter.write(String.valueOf(this.javaPath) + "\\bin\\java " + this.getProperty("javaOpts") + " -D" + this.getProperty("installDirProp") + "=%APPBASE% " + this.getProperty("mainClass") + " %1 %2 %3 %4 %5 %6 %7 %8 %9\r\n");
        fileWriter.write("set CLASSPATH=%OLDPATH%\r\n");
        fileWriter.close();
    }

    public void writeWindows12() throws IOException {
        File file = new File(this.installationDir, String.valueOf((String)this.getProperty("exeName")) + ".bat");
        FileWriter fileWriter = new FileWriter(file.toString());
        fileWriter.write("@echo off\r\n");
        fileWriter.write("set OLDPATH=%CLASSPATH%\r\n");
        fileWriter.write("set APPBASE=" + this.installationDir + "\r\n");
        String string = this.getProperty("winCommands.12").toString();
        if (string != null) {
            string = this.replace(string, '~', "%APPBASE%");
            string = this.replace(string, '!', this.javaPath);
            string = this.replace(string, '@', this.architecture);
            fileWriter.write(string);
            fileWriter.write("\r\n");
        }
        String string2 = this.getProperty("classpath.localJPDA").toString();
        string2 = string2.replace('/', '\\');
        string2 = this.replace(string2, '~', "%APPBASE%");
        string2 = this.replace(string2, '!', this.javaPath);
        string2 = this.replace(string2, '@', this.architecture);
        fileWriter.write("set CLASSPATH=" + string2 + ";%CLASSPATH%\r\n");
        fileWriter.write(String.valueOf(this.javaPath) + "\\bin\\java " + this.getProperty("javaOpts.1.2") + " -D" + this.getProperty("installDirProp") + "=%APPBASE% " + this.getProperty("mainClass") + " %1 %2 %3 %4 %5 %6 %7 %8 %9\r\n");
        fileWriter.write("set CLASSPATH=%OLDPATH%\r\n");
        fileWriter.close();
    }

    class InstallThread
    extends Thread {
        InstallThread() {
        }

        public void run() {
            Installer.this.doInstall();
        }
    }
}

