/*
 * SecretKeySpec.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto.spec;

import java.security.*;
import java.security.spec.*;
import java.util.*;
import javax.crypto.SecretKey;

public class SecretKeySpec implements KeySpec, SecretKey
{
	private static String FORMAT = "RAW";

	private byte[] key;
	private String algorithm;

	public SecretKeySpec(byte[] key, int offset, int len, String algorithm)
	{
		if (key == null)
			throw new IllegalArgumentException("key is null");

		if (key.length - offset < len)
			throw new IllegalArgumentException("bad offset/len");

		if (algorithm == null)
			throw new IllegalArgumentException("algorithm is null");

		this.key = new byte[len];
		System.arraycopy(key, offset, this.key, 0, len);
		this.algorithm = algorithm;
	}

	public SecretKeySpec(byte[] key, String algorithm)
	{
		this(key, 0, key.length, algorithm);
	}

	public boolean equals(Object obj)
	{
		if (this == obj)
			return true;
		if (!(obj instanceof SecretKey))
			return false;
		if (!algorithm.equalsIgnoreCase(this.algorithm))
			return false;
		/* we should also test if the algorithms are equivalent, but we don't know what the type is in the provider */

		return Arrays.equals(key, ((SecretKey) obj).getEncoded());
	}

	protected void finalize()
	{
		if (key != null)
			Arrays.fill(key, (byte) 0);
	}

	public String getAlgorithm()
	{
		return algorithm;
	}

	public byte[] getEncoded()
	{
		return (byte[]) key.clone();
	}

	public String getFormat()
	{
		return FORMAT;
	}

	public int hashCode()
	{
		int tmp = 0;

		for (int i = 1; i < key.length; i++)
			tmp += key[i] * i;

		return tmp ^ algorithm.toLowerCase().hashCode();
	}
}
