/*
 * RC5ParameterSpec.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto.spec;

import java.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec implements AlgorithmParameterSpec
{
	private int version;

	private int rounds;

	private int wordSize;

	private byte[] iv;

	public RC5ParameterSpec(int version, int rounds, int wordSize)
	{
		this.version = version;
		this.rounds = rounds;
		this.wordSize = wordSize;
		this.iv = null;
	}

	public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv)
	{
		this.version = version;
		this.rounds = rounds;
		this.wordSize = wordSize;
		this.iv = iv;
	}

	public boolean equals(Object obj)
	{
		if (this == obj)
			return true;

		if (this instanceof RC5ParameterSpec)
		{
			RC5ParameterSpec tmp = (RC5ParameterSpec) obj;
			return (tmp.version == version) && (tmp.rounds == rounds) && (tmp.wordSize == wordSize) && Arrays.equals(tmp.iv, iv);
		}

		return false;
	}


	public byte[] getIV()
	{
		return (iv == null) ? null : (byte[]) iv.clone();
	}

	public int getRounds()
	{
		return rounds;
	}

	public int getVersion()
	{
		return version;
	}

	public int getWordSize()
	{
		return wordSize;
	}
}
