/*
 * RC2ParameterSpec.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto.spec;

import java.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;

public class RC2ParameterSpec implements AlgorithmParameterSpec
{
	private int effectiveKeyBits;

	private byte[] iv;

	public RC2ParameterSpec(int effectiveKeyBits)
	{
		this.effectiveKeyBits = effectiveKeyBits;
		this.iv = null;
	}

	public RC2ParameterSpec(int effectiveKeyBits, byte[] iv)
	{
		this(effectiveKeyBits, iv, 0);
	}

	public RC2ParameterSpec(int effectiveKeyBits, byte[] iv, int offset)
	{
		if (iv == null)
			throw new IllegalArgumentException("iv is null");

		if (iv.length - offset < 8)
			throw new IllegalArgumentException("iv is too short");
		
		this.effectiveKeyBits = effectiveKeyBits;
		this.iv = new byte[8];
		
		System.arraycopy(iv, offset, this.iv, 0, 8);
	}

	public boolean equals(Object obj)
	{
		if (obj == this)
			return true;

		if (obj instanceof RC2ParameterSpec)
		{
			RC2ParameterSpec tmp = (RC2ParameterSpec) obj;
			return (tmp.effectiveKeyBits == effectiveKeyBits) && Arrays.equals(tmp.iv, iv);
		}

		return false;
	}

	public int getEffectiveKeyBits()
	{
		return effectiveKeyBits;
	}

	public byte[] getIV()
	{
		return (iv == null) ? null : (byte[]) iv.clone();
	}
}
