/*
 * PBEParameterSpec.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto.spec;

import java.security.*;
import java.security.spec.*;

public class PBEParameterSpec implements AlgorithmParameterSpec
{
	private byte[] salt;
	private int iterationCount;

	public PBEParameterSpec(byte[] salt, int iterationCount)
	{
		this.salt = (salt == null) ? null : (byte[]) salt.clone();

		this.iterationCount = iterationCount;
	}

	public final byte[] getSalt()
	{
		return (salt == null) ? null : (byte[]) salt.clone();
	}

	public final int getIterationCount()
	{
		return iterationCount;
	}
}
