/*
 * IvParameterSpec.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto.spec;

import java.util.Arrays;
import java.security.*;
import java.security.spec.*;

public class IvParameterSpec implements AlgorithmParameterSpec
{
	private byte[] iv;

	public IvParameterSpec(byte[] iv)
	{
		this(iv, 0, iv.length);
	}

	public IvParameterSpec(byte[] iv, int offset, int len)
	{
		if (iv == null)
			throw new IllegalArgumentException("iv is null");

		if (offset < 0 || len < 0 || iv.length - offset < len)
			throw new IllegalArgumentException("bad offset/length");

		this.iv = new byte[len];
		System.arraycopy(iv, offset, this.iv, 0, len);
	}

	protected void finalize()
	{
		if (iv != null)
			Arrays.fill(iv, (byte) 0);
	}

	public byte[] getIV()
	{
		return (byte[]) iv.clone();
	}
}
