/*
 * DHParameterSpec.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto.spec;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

public class DHParameterSpec implements AlgorithmParameterSpec
{
	private BigInteger p;
	private BigInteger g;
	private int l;

	public DHParameterSpec(BigInteger p, BigInteger g)
	{
		this.p = p;
		this.g = g;
		this.l = 0;
	}

	public DHParameterSpec(BigInteger p, BigInteger g, int l)
	{
		this.p = p;
		this.g = g;
		this.l = l;
	}

	public BigInteger getG()
	{
		return g;
	}

	public int getL()
	{
		return l;
	}

	public BigInteger getP()
	{
		return p;
	}
}
