/*
 * DESedeKeySpec.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESedeKeySpec implements KeySpec
{
	public static final int
		DES_EDE_KEY_LEN = 24;

	private byte[] key;

	public DESedeKeySpec(byte[] key) throws InvalidKeyException
	{
		this(key, 0);
	}

	public DESedeKeySpec(byte[] key, int offset) throws InvalidKeyException
	{
		if (key == null)
			throw new InvalidKeyException("key is null");

		if (key.length - offset < DES_EDE_KEY_LEN)
			throw new InvalidKeyException("key too short");

		this.key = new byte[DES_EDE_KEY_LEN];
		System.arraycopy(key, offset, this.key, 0, DES_EDE_KEY_LEN);
	}

	public byte[] getKey()
	{
		return (byte[]) key.clone();
	}

	public static boolean isParityAdjusted(byte[] key, int offset) throws InvalidKeyException
	{
		if (key == null)
			throw new InvalidKeyException("key is null");

		if (key.length - offset < DES_EDE_KEY_LEN)
			throw new InvalidKeyException("key too short");

		for (int i = 0; i < DES_EDE_KEY_LEN; i++)
		{
			byte b = key[i+offset];
			if (DESKeySpec.parityEven[b & 0xf] == DESKeySpec.parityEven[b >>> 4])
				return false;
		}
		return true;
	}
}
