/*
 * share.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto;

import java.util.*;
import java.security.*;

final class share
{
	private static String algorithmClassName(String type, String algorithm, Provider provider)
	{
		String aliasOf = provider.getProperty("Alg.Alias." + type + "." + algorithm);

		return provider.getProperty(type + "." + ((aliasOf == null) ? algorithm : aliasOf));
	}

	static Object[] getImplementation(String type, String algorithm, Provider provider) throws NoSuchAlgorithmException
	{
		if (provider == null)
		{
			Provider[] providers = Security.getProviders();

			for (int i = 0; i < providers.length; i++)
			{
				try
				{
					return getImplementation(type, algorithm, providers[i]);
				}
				catch (NoSuchAlgorithmException e)
				{
					// ignore this exception here
				}
			}
			throw new NoSuchAlgorithmException("Algorithm " + algorithm + " not available");
		}
		else
		{
			String className = algorithmClassName(type, algorithm, provider);

			if (className == null)
				throw new NoSuchAlgorithmException("Algorithm " + algorithm + " not available");

			try
			{
				return new Object[] { Class.forName(className).newInstance(), provider } ;
			}
			catch (ClassNotFoundException cnfe)
			{
				throw new NoSuchAlgorithmException("Class " + className + " not found");
			}
			catch (InstantiationException ie)
			{
				throw new NoSuchAlgorithmException("Class " + className + " cannot be instantiated");
			}
			catch (IllegalAccessException iae)
			{
				throw new NoSuchAlgorithmException("Class " + className + " cannot be accessed");
			}
		}
	}
}
