/*
 * NullCipherSpi.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto;

import java.security.*;
import java.security.spec.*;

class NullCipherSpi extends CipherSpi
{
	protected NullCipherSpi()
	{
	}

	protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen)
	{
		return engineUpdate(input, inputOffset, inputLen);
	}

	protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException
	{
		return engineUpdate(input, inputOffset, inputLen, output, outputOffset);
	}

	protected int engineGetBlockSize()
	{
		return 1;
	}

	protected byte[] engineGetIV()
	{
		/* spec says that if a cipher doesn't use IV, it returns null */
		return null;
	}

	protected int engineGetOutputSize(int i)
	{
		return i;
	}

	protected AlgorithmParameters engineGetParameters()
	{
		return null;
	}

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random)
	{
	}

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random)
	{
	}

    protected void engineInit(int opmode, Key key, SecureRandom random)
	{
	}

	protected void engineSetMode(String mode)
	{
	}

	protected void engineSetPadding(String padding)
	{
	}

	protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen)
	{
		byte[] temp = new byte[inputLen];
		System.arraycopy(input, inputOffset, temp, 0, inputLen);
		return temp;
	}

	protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException
	{
		if (input == null)
			return 0;

		if (output.length - outputOffset < inputLen)
			throw new ShortBufferException("output too small");

		System.arraycopy(input, inputOffset, output, outputOffset, inputLen);

		return inputLen;
	}
}
