/*
 * MacSpi.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto;

import java.security.*;
import java.security.spec.*;

public abstract class MacSpi
{
	public MacSpi()
	{
	}

	public Object clone() throws CloneNotSupportedException
	{
		if (this instanceof Cloneable)
			return super.clone();
		else
			throw new CloneNotSupportedException();
	}

	protected abstract byte[] engineDoFinal();

	protected abstract int engineGetMacLength();

	protected abstract void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException;

	protected abstract void engineReset();

	protected abstract void engineUpdate(byte input);

	protected abstract void engineUpdate(byte[] input, int offset, int len);
}
