/*
 * KeyGenerator.java
 *
 * This class is part of our JCE 1.2 cleanroom implementation
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package javax.crypto;

import java.security.*;
import java.security.spec.*;

public class KeyGenerator
{
	private KeyGeneratorSpi	spi;
	private Provider		provider;
	private String			algorithm;

	protected KeyGenerator(KeyGeneratorSpi keyGenSpi, Provider provider, String algorithm)
	{
		this.spi = keyGenSpi;
		this.provider = provider;
		this.algorithm = algorithm;
	}

	public final SecretKey generateKey()
	{
		return spi.engineGenerateKey();
	}

	public final String getAlgorithm()
	{
		return algorithm;
	}

	public static final KeyGenerator getInstance(String algorithm) throws NoSuchAlgorithmException
	{
		Object[] obj = share.getImplementation("KeyGenerator", algorithm, null);

		return new KeyGenerator((KeyGeneratorSpi) obj[0], (Provider) obj[1], algorithm);
	}

	public static final KeyGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException
	{
		Provider p = Security.getProvider(provider);

		if (p == null)
			throw new NoSuchProviderException("Provider " + provider + " not installed");

		Object[] obj = share.getImplementation("KeyGenerator", algorithm, p);

		return new KeyGenerator((KeyGeneratorSpi) obj[0], p, algorithm);
	}

	public final Provider getProvider()
	{
		return provider;
	}

	public final void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException
	{
		spi.engineInit(params, new SecureRandom());
	}

	public final void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException
	{
		spi.engineInit(params, random);
	}

	public final void init(int keysize)
	{
		spi.engineInit(keysize, new SecureRandom());
	}

	public final void init(int keysize, SecureRandom random)
	{
		spi.engineInit(keysize, random);
	}

	public final void init(SecureRandom random)
	{
		spi.engineInit(random);
	}
}
