{ PUSHDIR.PAS : Push specified or current directory into file \DIRSTACK.DAT

  Title   : PUSHDIR
  Language: Borland Pascal v5.0 or higher
  Version : 1.1
  Date    : Feb 15, 2000
  Author  : J R Ferguson
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com

  Usage   : In batch file, together with program POPDIR.
            Can also be used as a stand-alone command.
            Supports unlimited nesting.

  Example:
    PUSHDIR             save current directory
    CD ...              change current directory
    ...                 execute some commands
    ...                 this may include PUSHDIR and POPDIR commands
    POPDIR              back to the original directory

This program and its source may be used and copied freely without charge,
but  only  for non-commercial purposes. The author is not responsible for
any damage or loss of data that may be caused by using it.
}

program PushDir;

const
  OLDSTACKFILE = '\DIRSTACK.DAT';
  NEWSTACKFILE = '\DIRSTACK.$$$';

var
  OldStack,
  NewStack     : Text;
  Dir,Tmp      : String;
  i            : word;

begin
  Assign(NewStack,NewStackFile); Rewrite(NewStack);

  if ParamCount = 0 then begin GetDir(0,Dir); WriteLn(NewStack,Dir) end
  else for i:= 1 to ParamCount do WriteLn(NewStack,ParamStr(i));

  {$I-} Assign(OldStack,OLDSTACKFILE); Reset(OldStack); {$I+}
  if IOResult=0 then begin
    while not eof(OldStack) do begin
      ReadLn(OldStack,Dir);
      WriteLn(NewStack,Dir);
    end;
    Close(OldStack); Erase(OldStack);
  end;

  Close(NewStack); Rename(NewStack,OLDSTACKFILE);
end.
