{ POPDIR.PAS : Pop new "current directory" from file \DIRSTACK.DAT

  Title   : POPDIR
  Language: Borland Pascal v5.0 or higher
  Version : 1.1
  Date    : Feb 15, 2000
  Author  : J R Ferguson
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com

  Usage   : In batch file, together with program PUSHDIR.
            Can also be used as a stand-alone command.
            Supports unlimited nesting.

  Example:
    PUSHDIR             save current directory
    CD ...              change current directory
    ...                 execute some commands
    ...                 this may include PUSHDIR and POPDIR commands
    POPDIR              back to the original directory

This program and its source may be used and copied freely without charge,
but  only  for non-commercial purposes. The author is not responsible for
any damage or loss of data that may be caused by using it.
}

program PopDir;

const
  OLDSTACKFILE = '\DIRSTACK.DAT';
  NEWSTACKFILE = '\DIRSTACK.$$$';

var
  OldStack,
  NewStack     : Text;
  Dir,Tmp      : String;

begin
  {$I-} Assign(OldStack,OLDSTACKFILE); Reset(OldStack); {$I+}
  if (IOResult=0) and not eof(OldStack) then begin
    ReadLn(OldStack,Dir);
    if eof(OldStack) then begin Close(OldStack); Erase(OldStack); end
    else begin
      Assign(NewStack,NEWSTACKFILE); Rewrite(NewStack);
      repeat
        ReadLn(OldStack,Tmp);
        WriteLn(NewStack,Tmp);
      until eof(OldStack);
      Close(OldStack); Close(NewStack);
      Erase(OldStack); Rename(NewStack,OLDSTACKFILE);
    end;
    ChDir(Dir);
  end;
end.
