{ BASENUM.PAS : Integer number base conversion, radix 2-8-10-16, DOS version

  Title   : BASENUM
  Version : 1.1
  Date    : Feb 14, 2000
  Author  : J R Ferguson
  Language: Borland Pascal v7.0
  Usage   : MS-DOS program
  Download: Internet adsress: http://hello.to/ferguson
            To compile this program, you will need some units from my
            Pascal library JRFPAS, which can be downloaded from the same
            Internet website.
  E-mail  : j.r.ferguson@iname.com
}


{
--- Compiler options ---
}

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }

PROGRAM BASENUM;

uses DefLib, ChrLib, StpLib, CvtLib, ConLib, Crt;

const
  HeaderLine =  1;
  FirstLine  =  3;
  LastLine   = 22;
  PromptLine = 24;
  FromColumn =  7;
  ToColumn   = 47;
  StpMax     = 32;

type
  InputStatus= (StNumber,StRadix,StStop);

var
  FromNum,
  ToNum      : integer;
  CurLine    : integer;
  Status     : InputStatus;
  Stp        : StpTyp;

procedure Locate(line,column: integer); begin GotoXY(column,line) end;

procedure WriteN(n: integer; c: char);
  begin while n>0 do begin write(c);n:= n-1 end end;

procedure PageHeader;
  begin
    ClrScr;
    Locate(HeaderLine  , 4); write ('BASE NUMBER CONVERSION v1.1 (32 bit integer) (c) J.R. Ferguson 1998-2000');
    Locate(HeaderLine+1, 1); WriteN(80,'=');
    Locate(PromptLine-1, 1); WriteN(80,'=')
  end;

procedure Prompt(s: StpTyp);
  begin Locate(PromptLine,1); write(s,' '); ClrEol end;

procedure Scroll;
  begin
    if CurLine<LastLine then CurLine:= CurLine+1
    else begin
      Locate(FirstLine,1); DelLine;
      Locate(LastLine ,1); InsLine;
    end
  end;

function WaitKey(var Option: char; ValidOptions: StpTyp): char;
  begin
    repeat Option:= UppKey until StpcPos(ValidOptions,Option)>0;
    WaitKey:= Option
  end;

function ReadRadix(Kind: StpTyp; var st: InputStatus): integer;
  var Option: char;
  begin
    prompt(Kind + ' <B>=bin <O>=oct <H>=hex <D>=<S>=dec <U>=uns <X>=exit');
    case WaitKey(Option,'BOHDSUX') of
      'B'     : ReadRadix:=   2;
      'O'     : ReadRadix:=   8;
      'H'     : ReadRadix:=  16;
      'D','S' : ReadRadix:= -10;
      'U'     : ReadRadix:=  10;
      'X'     : st:= StStop
    end
  end;

procedure WriteRadix(base: integer);
  begin
    case base of
       2 : write('binary      ');
       8 : write('octal       ');
      16 : write('hexadecimal ');
      10 : write('unsigned dec');
     -10 : write('signed dec  ')
    end
  end;

procedure NewBaseNums(var st: InputStatus);
  begin
    Scroll;
    FromNum := ReadRadix('From:',st);
    if st<>StStop then begin
      Locate(CurLine, FromColumn); WriteRadix(FromNum);
      ToNum:= ReadRadix('To  :',st);
      if st<>StStop then begin
        Locate(CurLine,ToColumn); WriteRadix(ToNum)
      end
    end
  end;

procedure ReadString(var s: StpTyp; var st: InputStatus);
  const CAN = KeyCtrX;
        UPX = 88; { ord('X') }
  var c: char;
      n: integer;
      i: 0..StpMax;

  procedure InsChr; begin write(c); s:= s+c; i:= i+1 end;

  procedure DelChr;
    begin
      write(chr(AsciiBS)+' '+chr(AsciiBS));
      StpDel(s,StpLen(s),1); i:= i-1
    end;

  procedure cancel; begin while i>0 do DelChr end;

  begin {ReadString}
    Prompt('Enter a number  or  <CR>=new base numbers  or  <X>=exit');
    Scroll; Locate(CurLine,FromColumn); ClrEol;
    i:= 0; s:= ''; st:= StNumber;
    repeat
      c:= UppKey; n:= ord(c);
      if n in [KeyCtrH,KeyDel,CAN,KeyCR,UPX] then case n of
        KeyCtrH,
        KeyDel  : if i>0 then DelChr;
        CAN     : cancel;
        UPX     : begin cancel; st:= StStop end;
        KeyCR   : if i=0 then st:= StRadix
      end
      else if IsPrint(c) and (i<StpMax) then InsChr;
    until (n=KeyCR) or (st=StStop)
  end;

procedure Add(g: integer);
  begin
    case g of
       2 : write(' B');
       8 : write(' Q');
      16 : write(' H');
      10 : write(' U');
     -10 : write(' D');
    end
  end;

procedure Convert(var s: StpTyp; FromNum,ToNum: integer);
  var n : LongInt;
  begin
    if FromNum = -10 then n:= AtoL(s) else n:= AtoLB(s,FromNum);
    Case ToNum of
       2 : LtoABL(n,s, 2,32);
       8 : LtoABL(n,s, 8,10);
      16 : LtoABL(n,s,16, 8);
      10 : LtoAB (n,s,10   );
     -10 : LtoA  (n,s      )
    end;
  end;

begin {program}
  PageHeader;
  CurLine:= FirstLine-1; Status:= StRadix;
  while Status <> StStop do begin
    case Status of
      StRadix : NewBaseNums(Status);
      StNumber: begin
                  Add(FromNum); Convert(Stp,FromNum,ToNum);
                  Locate(CurLine,ToColumn); write(Stp); Add(ToNum)
                end;
      StStop  : { nothing }
    end;
    If Status <> StStop then ReadString(Stp,Status)
  end;
  Prompt(''); Locate(PromptLine-1,1); ClrEol
end.
