unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ToolWin, Menus, Grids, LogBase, LogNT, StdCtrls, ExtCtrls;

type
  TfrmMain = class(TForm)
    sgEventLog: TStringGrid;
    SMNTEventLog: TSMNTEventLog;
    pnlToolbar: TPanel;
    btnClose: TButton;
    btnRefresh: TButton;
    procedure btnCloseClick(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.btnCloseClick(Sender: TObject);
begin
  Close
end;

procedure TfrmMain.btnRefreshClick(Sender: TObject);
var
  UserName: array[0..1024] of Char;
  DomainName: array[0..1024] of Char;
  i, userNameLen, domainNameLen: Integer;
  Use: SID_NAME_USE;
begin
  SMNTEventLog.Source := ExtractFileName(Application.ExeName);
  SMNTEventLog.Active := True;

  sgEventLog.RowCount := SMNTEventLog.EventCount+1;
  sgEventLog.Cells[1, 0] := 'EventDate';
  sgEventLog.Cells[2, 0] := 'EventTime';
  sgEventLog.Cells[3, 0] := 'EventSource';
  sgEventLog.Cells[4, 0] := 'EventID';
  sgEventLog.Cells[5, 0] := 'UserName';
  sgEventLog.Cells[6, 0] := 'EventComputer';
  sgEventLog.Cells[7, 0] := 'EventType';

  for i := 1 to sgEventLog.RowCount-1 do
  begin
    SMNTEventLog.ReadEvent(i);
    sgEventLog.Cells[0, i] := IntToStr(i);

    sgEventLog.Cells[1, i] := DateToStr(SMNTEventLog.EventTime);
    sgEventLog.Cells[2, i] := TimeToStr(SMNTEventLog.EventTime);
    sgEventLog.Cells[3, i] := SMNTEventLog.EventSource;
    sgEventLog.Cells[4, i] := IntToStr(SMNTEventLog.EventID and $0FFFFFFF);

    UserNameLen := SizeOf(UserName);
    DomainNameLen := SizeOf(DomainName);
    if LookupAccountSID(nil, SMNTEventLog.EventSID, UserName, UserNameLen, DomainName, DomainNameLen, Use) then
      sgEventLog.Cells[5, i] := UserName
    else
      sgEventLog.Cells[5, i] := 'N/A';
    sgEventLog.Cells[6, i] := SMNTEventLog.EventComputer;

    case SMNTEventLog.EventType of
      elSuccess: sgEventLog.Cells[7, i] := 'Success';
      elInformation_Type: sgEventLog.Cells[7, i] := 'Information';
      elWarning_Type: sgEventLog.Cells[7, i] := 'Warning';
      elError_Type: sgEventLog.Cells[7, i] := 'Error';
      elAudit_Success: sgEventLog.Cells[7, i] := 'Audit Success';
    else // elAudit_Failure
      sgEventLog.Cells[7, i] := 'Audit Failure';
    end;

  end;
  if sgEventLog.RowCount < 2 then
    sgEventLog.RowCount := 2;
  sgEventLog.FixedRows := 1;

  SMNTEventLog.Active := False;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Application.Title := Caption;
  btnRefreshClick(Sender);
end;

end.
