unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, LogBase, LogApp;

type
  TfrmMain = class(TForm)
    SMAppLog: TSMAppLog;
    lbLog: TListBox;
    procedure SMAppLogActivate(Sender: TObject);
    procedure SMAppLogActiveControlChange(Sender: TObject);
    procedure SMAppLogActiveFormChange(Sender: TObject);
    procedure SMAppLogDeactivate(Sender: TObject);
    procedure SMAppLogException(Sender: TObject; E: Exception);
    function SMAppLogHelp(Command: Word; Data: Integer;
      var CallHelp: Boolean): Boolean;
    procedure SMAppLogHint(Sender: TObject);
    procedure SMAppLogIdle(Sender: TObject; var Done: Boolean);
    procedure SMAppLogMessage(var Msg: TMsg; var Handled: Boolean);
    procedure SMAppLogMinimize(Sender: TObject);
    procedure SMAppLogRestore(Sender: TObject);
    procedure SMAppLogSettingsChanged(Sender: TObject);
    procedure SMAppLogShowHint(var HintStr: String; var CanShow: Boolean;
      var HintInfo: THintInfo);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    procedure AddToLog(const s: string);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.AddToLog(const s: string);
begin
  if lbLog.Items.Count < 32000 then
  begin
    lbLog.Items.Add(DateToStr(Now) + ': ' + s);
    lbLog.TopIndex := lbLog.Items.Count-10
  end;
end;

procedure TfrmMain.SMAppLogActivate(Sender: TObject);
begin
  AddToLog('Application''s activated')
end;

procedure TfrmMain.SMAppLogActiveControlChange(Sender: TObject);
begin
  AddToLog('Changed the active control')
end;

procedure TfrmMain.SMAppLogActiveFormChange(Sender: TObject);
begin
  AddToLog('Active form changed')
end;

procedure TfrmMain.SMAppLogDeactivate(Sender: TObject);
begin
  AddToLog('Application''s deactivated')
end;

procedure TfrmMain.SMAppLogException(Sender: TObject; E: Exception);
begin
  AddToLog('Exception in application')
end;

function TfrmMain.SMAppLogHelp(Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  AddToLog('Help event called')
end;

procedure TfrmMain.SMAppLogHint(Sender: TObject);
begin
  AddToLog('Hint display event')
end;

procedure TfrmMain.SMAppLogIdle(Sender: TObject; var Done: Boolean);
begin
  AddToLog('Application''s idle')
end;

procedure TfrmMain.SMAppLogMessage(var Msg: TMsg; var Handled: Boolean);
begin
  AddToLog('Message callback')
end;

procedure TfrmMain.SMAppLogMinimize(Sender: TObject);
begin
  AddToLog('Application minimized')
end;

procedure TfrmMain.SMAppLogRestore(Sender: TObject);
begin
  AddToLog('Application restored')
end;

procedure TfrmMain.SMAppLogSettingsChanged(Sender: TObject);
begin
  AddToLog('Changed the setting of MS Windows')
end;

procedure TfrmMain.SMAppLogShowHint(var HintStr: String;
  var CanShow: Boolean; var HintInfo: THintInfo);
begin
  AddToLog('ShowHint event')
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  SMAppLog.Active := True
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  SMAppLog.Active := False
end;

end.
