unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Grids, DBGrids, Db, DBTables, StdCtrls, LogBase, LogDS;

type
  TfrmMain = class(TForm)
    lbLog: TListBox;
    dSrc: TDataSource;
    tblCustomer: TTable;
    SMDatasetLog: TSMDatasetLog;
    Splitter: TSplitter;
    pnlTop: TPanel;
    DBGrid: TDBGrid;
    gbFilter: TGroupBox;
    cbActiveChanged: TCheckBox;
    cbEditingChanged: TCheckBox;
    cbDataSetChanged: TCheckBox;
    cbDataSetScrolled: TCheckBox;
    cbLayoutChanged: TCheckBox;
    cbRecordChanged: TCheckBox;
    cbUpdateData: TCheckBox;
    procedure SMDatasetLogChange(Sender: TObject; State: TSMLDBTypeEvent;
      Field: TField; var LogText: string);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cbActiveChangedClick(Sender: TObject);
    procedure cbEditingChangedClick(Sender: TObject);
    procedure cbDataSetChangedClick(Sender: TObject);
    procedure cbDataSetScrolledClick(Sender: TObject);
    procedure cbLayoutChangedClick(Sender: TObject);
    procedure cbRecordChangedClick(Sender: TObject);
    procedure cbUpdateDataClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.SMDatasetLogChange(Sender: TObject;
  State: TSMLDBTypeEvent; Field: TField; var LogText: string);
const
  ASMLDBTypeEvents: array[TSMLDBTypeEvent] of string =
    ('ActiveChanged',
     'EditingChanged',
     'DataSetChanged',
     'DataSetScrolled',
     'LayoutChanged',
     'RecordChanged',
     'UpdateData');
begin
  lbLog.Items.Add(ASMLDBTypeEvents[State]);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  SMDatasetLog.Active := True
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  SMDatasetLog.Active := False
end;


procedure TfrmMain.cbActiveChangedClick(Sender: TObject);
begin
  if cbActiveChanged.Checked then
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents + [dbeActiveChanged]
  else
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents - [dbeActiveChanged]
end;

procedure TfrmMain.cbEditingChangedClick(Sender: TObject);
begin
  if cbEditingChanged.Checked then
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents + [dbeEditingChanged]
  else
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents - [dbeEditingChanged]
end;

procedure TfrmMain.cbDataSetChangedClick(Sender: TObject);
begin
  if cbDataSetChanged.Checked then
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents + [dbeDataSetChanged]
  else
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents - [dbeDataSetChanged]
end;

procedure TfrmMain.cbDataSetScrolledClick(Sender: TObject);
begin
  if cbDataSetScrolled.Checked then
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents + [dbeDataSetScrolled]
  else
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents - [dbeDataSetScrolled]
end;

procedure TfrmMain.cbLayoutChangedClick(Sender: TObject);
begin
  if cbLayoutChanged.Checked then
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents + [dbeLayoutChanged]
  else
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents - [dbeLayoutChanged]
end;

procedure TfrmMain.cbRecordChangedClick(Sender: TObject);
begin
  if cbRecordChanged.Checked then
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents + [dbeRecordChanged]
  else
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents - [dbeRecordChanged]
end;

procedure TfrmMain.cbUpdateDataClick(Sender: TObject);
begin
  if cbUpdateData.Checked then
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents + [dbeUpdateData]
  else
    SMDatasetLog.FilterEvents := SMDatasetLog.FilterEvents - [dbeUpdateData]
end;

end.
