unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Db, DBTables, StdCtrls, ComCtrls, SMIBase, SMIWiz,
  ExtCtrls;

type
  TfrmMain = class(TForm)
    dSrc: TDataSource;
    tbl: TTable;
    SMIWizardDlg: TSMIWizardDlg;
    PageControl: TPageControl;
    tsCountries: TTabSheet;
    tsErrorLog: TTabSheet;
    DBGrid: TDBGrid;
    lbErrorLog: TListBox;
    pnlTop: TPanel;
    btnImport: TButton;
    tsImportedValues: TTabSheet;
    lbImportedValues: TListBox;
    btnAbout: TButton;
    procedure btnImportClick(Sender: TObject);
    procedure SMIWizardDlgErrorEvent(Sender: TObject; Error: Exception;
      var Abort: Boolean);
    procedure SMIWizardDlgBeforeExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SMIWizardDlgGetCellParams(Sender: TObject; Field: TField;
      var Value: Variant);
    procedure btnAboutClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.btnImportClick(Sender: TObject);
begin
  SMIWizardDlg.Execute
end;

procedure TfrmMain.SMIWizardDlgGetCellParams(Sender: TObject;
  Field: TField; var Value: Variant);
begin
  if lbImportedValues.Items.Count < 30000 then
    lbImportedValues.Items.Add(Field.FieldName + ' = ' + VarToStr(Value));
end;

procedure TfrmMain.SMIWizardDlgErrorEvent(Sender: TObject;
  Error: Exception; var Abort: Boolean);
begin
  if lbErrorLog.Items.Count < 30000 then
    lbErrorLog.Items.Add(Error.Message);
end;

procedure TfrmMain.SMIWizardDlgBeforeExecute(Sender: TObject);
begin
  lbErrorLog.Items.Clear;
  lbImportedValues.Items.Clear;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  tbl.DatabaseName := ExtractFilePath(Application.ExeName);
  tbl.Open;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  tbl.Close;
end;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  SMIWizardDlg.AboutSMI
end;

end.
