unit SPManager;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, O2Plan, jpeg, rxgif,
  ExtDlgs, StrF, ClipBrd, PEConsts, PlanUtils;

type
  TStandardPicturesForm = class(TForm)
    SPListBox: TListBox;
    SPImage: TImage;
    AddButton: TBitBtn;
    RenameButton: TBitBtn;
    SelectPictureButton: TBitBtn;
    DeleteButton: TBitBtn;
    HelpButton: TBitBtn;
    CloseButton: TBitBtn;
    PictureTypeLabel: TLabel;
    SelectPictureDialog: TOpenPictureDialog;
    CopyButton: TBitBtn;
    PasteButton: TBitBtn;
    TransparentCheck: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SPListBoxClick(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure RenameButtonClick(Sender: TObject);
    procedure SelectPictureButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure CopyButtonClick(Sender: TObject);
    procedure PasteButtonClick(Sender: TObject);
    procedure TransparentCheckClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetButtons;
    procedure UpdatePicture;
  public
    { Public declarations }
    FPlan : TOxygenPlan;
    FWasChanges : Boolean;
  end;

var
  StandardPicturesForm: TStandardPicturesForm;

implementation

{$R *.DFM}

// private
procedure TStandardPicturesForm.SetButtons;
begin
  RenameButton.Enabled := (SPListBox.ItemIndex >= 0);
  SelectPictureButton.Enabled := RenameButton.Enabled;
  DeleteButton.Enabled := RenameButton.Enabled;
  CopyButton.Enabled := RenameButton.Enabled;
  PasteButton.Enabled := RenameButton.Enabled;
end;

procedure TStandardPicturesForm.UpdatePicture;
  var i : Integer;
begin
  i := SPListBox.ItemIndex;
  if (i >= 0) then try
    SPImage.Picture.Assign(FPlan.Pictures[i]);
    PictureTypeLabel.Caption := PlanUtils.GetPictureType(SPImage.Picture);
    try TransparentCheck.Checked := FPlan.Pictures[i].Graphic.Transparent except end;
    SPImage.Transparent := TransparentCheck.Checked;
  except
    on E : Exception do begin
      SPImage.Picture.Assign(nil);
      PictureTypeLabel.Caption := '';
      MessageDlg(sErrorGettingImage+E.Message,mtError,[mbOk],0);
    end;
  end;
end;

// published
procedure TStandardPicturesForm.FormCreate(Sender: TObject);
begin
  FPlan := nil;
  FWasChanges := False;
end;

procedure TStandardPicturesForm.FormShow(Sender: TObject);
  var i : Integer;
begin
  if (FPlan = nil) then begin
    Close;
    Exit;
  end;
  for i := 1 to FPlan.PictureCount do SPListBox.Items.Add(FPlan.Pictures[i-1].Name);
  with SPListBox do if (Items.Count > 0) then begin
    ItemIndex := 0;
    UpdatePicture;
  end;
  SetButtons;
end;

procedure TStandardPicturesForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //
end;

procedure TStandardPicturesForm.SPListBoxClick(Sender: TObject);
begin
  UpdatePicture;
end;

procedure TStandardPicturesForm.AddButtonClick(Sender: TObject);
  label m1;
  var PName : String;
      Picture : TPicture;
      i : Integer;
begin
  if not SelectPictureDialog.Execute then Exit;
  Picture := TPicture.Create;
  try
    Picture.LoadFromFile(SelectPictureDialog.FileName);
    if not Picture.Graphic.Empty then begin
m1:
      i := 1;
      while (FPlan.PictureIndex('StdPict'+IntToStr(i)) >= 0) do Inc(i);
      PName := 'StdPict'+IntToStr(i);
      if InputQuery(sAddStdPictureCaption,sAddStdPicturePrompt,PName) then begin
        PName := StrF.DeleteChar(PName,',');
        if (FPlan.PictureIndex(PName) >= 0) then begin
          MessageDlg(Format(sStdPictureAlreadyExists,[PName]),mtError,[mbOk],0);
          goto m1;
        end;
        FPlan.AddPicture(PName,Picture);
        i := SPListBox.Items.Add(PName);
        SPListBox.ItemIndex := i;
        SPListBoxClick(Self);
        FWasChanges := True;
      end;
    end;
  except
    Picture.Free;
    raise;
  end;
  SetButtons;
end;

procedure TStandardPicturesForm.RenameButtonClick(Sender: TObject);
  var PName : String;
      i : Integer;
begin
  i := SPListBox.ItemIndex;
  if (i < 0) then Exit;
  PName := SPListBox.Items[i];
  if InputQuery(sRenameStdPictureCaption,sRenameStdPicturePrompt,PName) then begin
    if (FPlan.PictureIndex(PName) >= 0) then begin
      MessageDlg(Format(sStdPictureAlreadyExists,[PName]),mtError,[mbOk],0);
      Exit;
    end;
    FPlan.Pictures[i].Name := PName;
    O2Plan.RenameStdPicture(FPlan,SPListBox.Items[i],PName);
    SPListBox.Items[i] := PName;
    FWasChanges := True;
  end;
end;

procedure TStandardPicturesForm.SelectPictureButtonClick(Sender: TObject);
  var i : Integer;
begin
  i := SPListBox.ItemIndex;
  if (i < 0) then Exit;
  if not SelectPictureDialog.Execute then Exit;
  FPlan.Pictures[i].LoadFromFile(SelectPictureDialog.FileName);
  SPImage.Picture.Assign(FPlan.Pictures[i]);
  FWasChanges := True;
end;

procedure TStandardPicturesForm.DeleteButtonClick(Sender: TObject);
  var i, rc : Integer;
      s : String;
begin
  i := SPListBox.ItemIndex;
  if (i < 0) then Exit;
  s := SPListBox.Items[i];
  rc := StandardPictureReferenceCount(FPlan,s);
  if (rc > 0) then begin
    MessageDlg(Format(sStdPictureHasReferences,[s,rc]),mtWarning,[mbOk],0);
    Exit;
  end;
  if (MessageDlg(Format(sStdPictureDeleteConfirm,[s]),mtConfirmation,mbYesNoCancel,0) <> mrYes) then Exit;
  FPlan.DeletePicture(i);
  SPListBox.Items.Delete(i);
  FWasChanges := True;
  if (i > 0) then SPListBox.ItemIndex := i-1 else if (SPListBox.Items.Count > 0) then SPListBox.ItemIndex := 0;
  if (SPListBox.ItemIndex >= 0) then SPListBoxClick(Self) else begin
    SPImage.Picture.Assign(nil);
    PictureTypeLabel.Caption := '';
  end;
  SetButtons;
end;

procedure TStandardPicturesForm.CopyButtonClick(Sender: TObject);
begin
  Clipboard.Assign(SPImage.Picture);
end;

procedure TStandardPicturesForm.PasteButtonClick(Sender: TObject);
  var i : Integer;
begin
  i := SPListBox.ItemIndex;
  if (i < 0) then Exit;
  if Clipboard.HasFormat(CF_PICTURE) then
    if (MessageDlg(sStdPictureReplaceConfirm,mtConfirmation,mbYesNoCancel,0) = mrYes) then begin
      FPlan.Pictures[i].Assign(Clipboard);
      SPListBoxClick(Self);
      FWasChanges := True;
    end;
end;

procedure TStandardPicturesForm.TransparentCheckClick(Sender: TObject);
  var g : TGraphic;
      i : Integer;
begin
  i := SPListBox.ItemIndex;
  if (i < 0) then Exit;
  g := FPlan.Pictures[i].Graphic;
  if (g <> nil) then try g.Transparent := TransparentCheck.Checked except end;
  SPImage.Transparent := TransparentCheck.Checked;
  FWasChanges := True;
end;

end.
