// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'mySQLTypes.pas' rev: 5.00

#ifndef mySQLTypesHPP
#define mySQLTypesHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <mySQLCP.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Bde.hpp>	// Pascal unit
#include <WinSock.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Mysqltypes
{
//-- type declarations -------------------------------------------------------
#pragma pack(push, 1)
struct TVio
{
	
} ;
#pragma pack(pop)

typedef TVio *PVio;

typedef int MY_Socket;

#pragma option push -b-
enum mySQL_Status { MYSQL_STATUS_READY, MYSQL_STATUS_GET_RESULT, MYSQL_STATUS_USE_RESULT };
#pragma option pop

struct TNET;
typedef TNET *PNET;

struct TNET
{
	TVio *VIO;
	int FD;
	int FCntl;
	Byte *Buff;
	Byte *Buff_End;
	Byte *Write_Pos;
	Byte *Read_Pos;
	char Last_Error[200];
	unsigned Last_Errno;
	unsigned Max_Packet;
	unsigned Timeout;
	unsigned Pkt_NR;
	Byte Error;
	Byte Return_Errno;
	Byte Compress;
	Byte No_Send_OK;
	unsigned Remain_IN_Buf;
	unsigned Length;
	unsigned Buf_Length;
	unsigned Where_B;
	unsigned *Return_Status;
	Byte Reading_OR_Writing;
	char Save_Char;
} ;

typedef Byte Enum_Field_Types;

struct TMYSQL_FIELD;
typedef TMYSQL_FIELD *PMYSQL_FIELD;

struct TMYSQL_FIELD
{
	char *Name;
	char *Table;
	char *Def;
	Enum_Field_Types _Type;
	unsigned Length;
	unsigned Max_Length;
	unsigned Flags;
	unsigned Decimals;
} ;

typedef TMYSQL_FIELD TMYSQL_FIELDS[67108863];

typedef TMYSQL_FIELD *PMYSQL_FIELDS;

struct TUSED_MEM;
typedef TUSED_MEM *PUSED_MEM;

struct TUSED_MEM
{
	TUSED_MEM *Next;
	unsigned Left;
	unsigned Size;
} ;

typedef void __fastcall (*Error_Proc)(void);

struct TMEM_ROOT;
typedef TMEM_ROOT *PMEM_ROOT;

struct TMEM_ROOT
{
	TUSED_MEM *Free;
	TUSED_MEM *Used;
	TUSED_MEM *Pre_Alloc;
	unsigned Min_Malloc;
	unsigned Block_Size;
	Error_Proc Error_Handler;
} ;

struct TMYSQL_OPTIONS;
typedef TMYSQL_OPTIONS *PMYSQL_OPTIONS;

struct TMYSQL_OPTIONS
{
	unsigned Connect_Timeout;
	unsigned Client_Flag;
	Byte Compress;
	Byte Named_Pipe;
	unsigned Port;
	char *Host;
	char *Init_Command;
	char *User;
	char *Password;
	char *Unix_Socket;
	char *DB;
	char *my_Cnf_File;
	char *my_Cnf_Group;
	char *Charset_Dir;
	char *Charset_Name;
	Byte Use_SSL;
	char *SSL_Key;
	char *SSL_Cert;
	char *SSL_Ca;
	char *SSL_Capath;
} ;

#pragma pack(push, 1)
struct TCHARSET_INFO
{
	
} ;
#pragma pack(pop)

typedef TCHARSET_INFO *PCHARSET_INFO;

struct TMYSQL;
typedef TMYSQL *PMYSQL;

struct TMYSQL
{
	TNET NET;
	char *Connector_FD;
	char *Host;
	char *user;
	char *passwd;
	char *Unix_Socket;
	char *Server_Version;
	char *Host_Info;
	char *Info;
	char *DB;
	unsigned Port;
	unsigned Client_Flag;
	unsigned Server_Capabilities;
	unsigned Protocol_Version;
	unsigned Field_Count;
	unsigned Server_Status;
	unsigned Thread_ID;
	__int64 Affected_Rows;
	__int64 Insert_ID;
	__int64 Extra_Info;
	unsigned Packet_Length;
	mySQL_Status Status;
	TMYSQL_FIELD *Fields;
	TMEM_ROOT Field_Alloc;
	Byte Free_ME;
	Byte Reconnect;
	TMYSQL_OPTIONS Options;
	char Scramble_Buff[9];
	TCHARSET_INFO *Charset;
	unsigned Server_Language;
} ;

typedef char *TMYSQL_ROW[536870911];

typedef char * *PMYSQL_ROW;

struct TMYSQL_ROWS;
typedef TMYSQL_ROWS *PMYSQL_ROWS;

struct TMYSQL_ROWS
{
	TMYSQL_ROWS *Next;
	char * *Ddata;
} ;

struct TMYSQL_DATA;
typedef TMYSQL_DATA *PMYSQL_DATA;

struct TMYSQL_DATA
{
	__int64 Rows;
	unsigned Fields;
	TMYSQL_ROWS *Data;
	TMEM_ROOT Alloc;
} ;

struct TMYSQL_RES;
typedef TMYSQL_RES *PMYSQL_RES;

struct TMYSQL_RES
{
	__int64 Row_Count;
	int Field_Count;
	int Current_Field;
	TMYSQL_FIELD *Fields;
	TMYSQL_DATA *Data;
	TMYSQL_ROWS *Data_Cursor;
	TMEM_ROOT Field_Alloc;
	char * *Row;
	char * *Current_Row;
	int *Lengths;
	TMYSQL *Handle;
	Byte Eof;
} ;

#pragma option push -b-
enum mysql_option { MYSQL_OPT_CONNECT_TIMEOUT, MYSQL_OPT_COMPRESS, MYSQL_OPT_NAMED_PIPE, MYSQL_INIT_COMMAND, 
	MYSQL_READ_DEFAULT_FILE, MYSQL_READ_DEFAULT_GROUP, MYSQL_SET_CHARSET_DIR, MYSQL_SET_CHARSET_NAME };
	
#pragma option pop

typedef int TFieldArray[256];

typedef Set<char, 0, 255>  TTrueArray;

typedef Set<char, 0, 255>  TFalseArray;

#pragma option push -b-
enum TFldType { FT_UNK, FT_INT, FT_DATETIME, FT_DATE, FT_TIME, FT_CURRENCY, FT_FLOAT, FT_STRING, FT_BOOL 
	};
#pragma option pop

struct StrRec
{
	int allocSiz;
	int refCnt;
	int length;
} ;

typedef short *PSmallInt;

typedef Word *PWordBool;

struct TPropRec
{
	Word Prop;
	Word Group;
} ;

struct TBlobItem
{
	Classes::TMemoryStream* Blob;
} ;

struct TmySQLBookMark;
typedef TmySQLBookMark *PmySQLBookMark;

struct TmySQLBookMark
{
	__int64 Position;
} ;

struct TFieldStatus;
typedef TFieldStatus *PFieldStatus;

struct TFieldStatus
{
	short isNULL;
	BOOL Changed;
} ;

#pragma option push -b-
enum TRecordState { tsNoPos, tsPos, tsFirst, tsLast, tsEmpty, tsClosed };
#pragma option pop

#pragma option push -b-
enum TDir { tdUndefined, tdNext, tdPrev };
#pragma option pop

struct TDBOptions
{
	AnsiString User;
	AnsiString Password;
	AnsiString DatabaseName;
	unsigned Port;
	AnsiString Host;
} ;

#pragma option push -b-
enum TConnectOption { coLongPassword, coFoundRows, coLongFlag, coConnectDatabase, coNoSchema, coCompress, 
	coODBC, coLocalFiles, coIgnoreSpaces };
#pragma option pop

typedef Set<TConnectOption, coLongPassword, coIgnoreSpaces>  TConnectOptions;

class DELPHICLASS TContainer;
class PASCALIMPLEMENTATION TContainer : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TList* FItems;
	
public:
	__fastcall TContainer(void);
	__fastcall virtual ~TContainer(void);
	void * __fastcall At(int Index);
	void __fastcall AtDelete(int Index);
	void __fastcall AtFree(int Index);
	void __fastcall AtInsert(int Index, void * Item);
	void __fastcall AtPut(int Index, void * Item);
	void __fastcall Clear(void);
	void __fastcall Delete(void * Item);
	void __fastcall DeleteAll(void);
	void __fastcall Error(int Code, int Info);
	void __fastcall FreeAll(void);
	void __fastcall FreeItem(void * Item);
	void * __fastcall Get(int AIndex);
	int __fastcall GetCount(void);
	int __fastcall IndexOf(void * Item);
	virtual void __fastcall Insert(void * Item);
	void __fastcall Pack(void);
	void __fastcall Put(int AIndex, void * APointer);
	int __fastcall GetCapacity(void);
	void __fastcall SetCapacity(int NewCapacity);
	__property int Count = {read=GetCount, nodefault};
	__property void * Items[int index] = {read=Get, write=Put};
	__property int Capacity = {read=GetCapacity, write=SetCapacity, nodefault};
};


class DELPHICLASS TBaseObject;
class PASCALIMPLEMENTATION TBaseObject : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	System::TObject* FParent;
	TContainer* FContainer;
	
public:
	__property TContainer* Container = {read=FContainer, write=FContainer};
	__property System::TObject* Parent = {read=FParent, write=FParent};
	__fastcall TBaseObject(System::TObject* P, TContainer* Container);
	__fastcall virtual ~TBaseObject(void);
};


typedef unsigned __stdcall (*Tmysql_errno)(PMYSQL _mysql);

typedef char * __stdcall (*Tmysql_error)(PMYSQL _mysql);

typedef PMYSQL __stdcall (*Tmysql_init)(PMYSQL _mysql);

typedef PMYSQL __stdcall (*Tmysql_real_connect)(PMYSQL _mysql, const char * host, const char * user, 
	const char * passwd, const char * db, unsigned port, const char * unix_socket, unsigned clientflag)
	;

typedef void __stdcall (*Tmysql_close)(PMYSQL sock);

typedef int __stdcall (*Tmysql_select_db)(PMYSQL _mysql, const char * db);

typedef int __stdcall (*Tmysql_query)(PMYSQL _mysql, const char * q);

typedef int __fastcall (*Tmysql_refresh)(PMYSQL _mysql, unsigned refresh_options);

typedef int __stdcall (*Tmysql_kill)(PMYSQL _mysql, unsigned pid);

typedef int __stdcall (*Tmysql_ping)(PMYSQL _mysql);

typedef char * __stdcall (*Tmysql_stat)(PMYSQL _mysql);

typedef char * __stdcall (*Tmysql_get_server_info)(PMYSQL _mysql);

typedef char * __stdcall (*Tmysql_get_client_info)(void);

typedef char * __stdcall (*Tmysql_get_host_info)(PMYSQL _mysql);

typedef unsigned __stdcall (*Tmysql_get_proto_info)(PMYSQL _mysql);

typedef PMYSQL_RES __stdcall (*Tmysql_list_dbs)(PMYSQL _mysql, const char * wild);

typedef PMYSQL_RES __stdcall (*Tmysql_list_tables)(PMYSQL _mysql, const char * wild);

typedef PMYSQL_RES __stdcall (*Tmysql_store_result)(PMYSQL _mysql);

typedef PMYSQL_RES __stdcall (*Tmysql_use_result)(PMYSQL _mysql);

typedef void __stdcall (*Tmysql_free_result)(PMYSQL_RES result);

typedef void __stdcall (*Tmysql_data_seek)(PMYSQL_RES result, __int64 offset);

typedef unsigned __stdcall (*Tmysql_field_seek)(PMYSQL_RES result, unsigned offset);

typedef PMYSQL_ROW __stdcall (*Tmysql_fetch_row)(PMYSQL_RES result);

typedef Windows::PLongint __stdcall (*Tmysql_fetch_lengths)(PMYSQL_RES result);

typedef PMYSQL_FIELD __stdcall (*Tmysql_fetch_field)(PMYSQL_RES result);

typedef unsigned __stdcall (*Tmysql_escape_string)(char * _to, const char * from, unsigned from_length
	);

#pragma option push -b-
enum TSQLToken { stUnknown, stTableName, stFieldName, stAscending, stDescending, stSelect, stFrom, stWhere, 
	stGroupBy, stHaving, stUnion, stPlan, stOrderBy, stForUpdate, stEnd, stPredicate, stValue, stIsNull, 
	stIsNotNull, stLike, stAnd, stOr, stNumber, stAllFields, stComment, stDistinct, stCreate, stShow, stInsert, 
	stUpdate };
#pragma option pop

//-- var, const, procedure ---------------------------------------------------
static const Shortint NOT_NULL_FLAG = 0x1;
static const Shortint PRI_KEY_FLAG = 0x2;
static const Shortint UNIQUE_KEY_FLAG = 0x4;
static const Shortint MULTIPLE_KEY_FLAG = 0x8;
static const Shortint BLOB_FLAG = 0x10;
static const Shortint UNSIGNED_FLAG = 0x20;
static const Shortint ZEROFILL_FLAG = 0x40;
static const Byte BINARY_FLAG = 0x80;
static const Word ENUM_FLAG = 0x100;
static const Word AUTO_INCREMENT_FLAG = 0x200;
static const Word TIMESTAMP_FLAG = 0x400;
static const Word SET_FLAG = 0x800;
static const Word NUM_FLAG = 0x8000;
static const Word PART_KEY_FLAG = 0x4000;
static const Word GROUP_FLAG = 0x8000;
static const int UNIQUE_FLAG = 0x10000;
static const Shortint REFRESH_GRANT = 0x1;
static const Shortint REFRESH_LOG = 0x2;
static const Shortint REFRESH_TABLES = 0x4;
static const Shortint REFRESH_HOSTS = 0x8;
static const Shortint REFRESH_STATUS = 0x10;
static const Shortint REFRESH_THREADS = 0x20;
static const Shortint REFRESH_SLAVE = 0x40;
static const Byte REFRESH_MASTER = 0x80;
static const Word REFRESH_READ_LOCK = 0x4000;
static const Word REFRESH_FAST = 0x8000;
static const Shortint CLIENT_LONG_PASSWORD = 0x1;
static const Shortint CLIENT_FOUND_ROWS = 0x2;
static const Shortint CLIENT_LONG_FLAG = 0x4;
static const Shortint CLIENT_CONNECT_WITH_DB = 0x8;
static const Shortint CLIENT_NO_SCHEMA = 0x10;
static const Shortint CLIENT_COMPRESS = 0x20;
static const Shortint CLIENT_ODBC = 0x40;
static const Byte CLIENT_LOCAL_FILES = 0x80;
static const Word CLIENT_IGNORE_SPACE = 0x100;
static const Word CLIENT_INTERACTIVE = 0x400;
static const Word CLIENT_SSL = 0x800;
static const Word CLIENT_IGNORE_SIGPIPE = 0x1000;
static const Word CLIENT_TRANSACTIONS = 0x2004;
static const Shortint SERVER_STATUS_IN_TRANS = 0x1;
static const Shortint SERVER_STATUS_AUTOCOMMIT = 0x2;
static const Byte MYSQL_ERRMSG_SIZE = 0xc8;
static const Shortint NET_READ_TIMEOUT = 0x1e;
static const Shortint NET_WRITE_TIMEOUT = 0x3c;
static const Word NET_WAIT_TIMEOUT = 0x7080;
static const Shortint FIELD_TYPE_DECIMAL = 0x0;
static const Shortint FIELD_TYPE_TINY = 0x1;
static const Shortint FIELD_TYPE_SHORT = 0x2;
static const Shortint FIELD_TYPE_LONG = 0x3;
static const Shortint FIELD_TYPE_FLOAT = 0x4;
static const Shortint FIELD_TYPE_DOUBLE = 0x5;
static const Shortint FIELD_TYPE_NULL = 0x6;
static const Shortint FIELD_TYPE_TIMESTAMP = 0x7;
static const Shortint FIELD_TYPE_LONGLONG = 0x8;
static const Shortint FIELD_TYPE_INT24 = 0x9;
static const Shortint FIELD_TYPE_DATE = 0xa;
static const Shortint FIELD_TYPE_TIME = 0xb;
static const Shortint FIELD_TYPE_DATETIME = 0xc;
static const Shortint FIELD_TYPE_YEAR = 0xd;
static const Shortint FIELD_TYPE_NEWDATE = 0xe;
static const Byte FIELD_TYPE_ENUM = 0xf7;
static const Byte FIELD_TYPE_SET = 0xf8;
static const Byte FIELD_TYPE_TINY_BLOB = 0xf9;
static const Byte FIELD_TYPE_MEDIUM_BLOB = 0xfa;
static const Byte FIELD_TYPE_LONG_BLOB = 0xfb;
static const Byte FIELD_TYPE_BLOB = 0xfc;
static const Byte FIELD_TYPE_VAR_STRING = 0xfd;
static const Byte FIELD_TYPE_STRING = 0xfe;
static const Shortint FIELD_TYPE_CHAR = 0x1;
static const Byte FIELD_TYPE_INTERVAL = 0xf7;
static const Shortint NAME_LEN = 0x40;
static const Shortint HOSTNAME_LENGTH = 0x3c;
static const Shortint USERNAME_LENGTH = 0x10;
#define LOCAL_HOST "localhost"
#define MYSQL_SERVICENAME "MySql"
#define DELIMITERS " .:;,+-<>/*%^=()[]|&~@#$\\`{}!?\n\r"
static const Word MYSQL_PORT = 0xcea;
extern PACKAGE __int64 MYSQL_COUNT_ERROR;
#define DLL "libmysql.dll"
extern PACKAGE unsigned SQLLibraryHandle;
static const int strsz = 0xc;
extern PACKAGE Tmysql_errno mysql_errno;
extern PACKAGE Tmysql_error mysql_error;
extern PACKAGE Tmysql_init mysql_init;
extern PACKAGE Tmysql_real_connect mysql_real_connect;
extern PACKAGE Tmysql_close mysql_close;
extern PACKAGE Tmysql_select_db mysql_select_db;
extern PACKAGE Tmysql_query mysql_query;
extern PACKAGE Tmysql_refresh mysql_refresh;
extern PACKAGE Tmysql_kill mysql_kill;
extern PACKAGE Tmysql_ping mysql_ping;
extern PACKAGE Tmysql_stat mysql_stat;
extern PACKAGE Tmysql_get_server_info mysql_get_server_info;
extern PACKAGE Tmysql_get_client_info mysql_get_client_info;
extern PACKAGE Tmysql_get_host_info mysql_get_host_info;
extern PACKAGE Tmysql_get_proto_info mysql_get_proto_info;
extern PACKAGE Tmysql_list_dbs mysql_list_dbs;
extern PACKAGE Tmysql_list_tables mysql_list_tables;
extern PACKAGE Tmysql_store_result mysql_store_result;
extern PACKAGE Tmysql_use_result mysql_use_result;
extern PACKAGE Tmysql_free_result mysql_free_result;
extern PACKAGE Tmysql_data_seek mysql_data_seek;
extern PACKAGE Tmysql_field_seek mysql_field_seek;
extern PACKAGE Tmysql_fetch_row mysql_fetch_row;
extern PACKAGE Tmysql_fetch_lengths mysql_fetch_lengths;
extern PACKAGE Tmysql_fetch_field mysql_fetch_field;
extern PACKAGE Tmysql_escape_string mysql_escape_string;
#define SQLSections (System::Set<TSQLToken, stUnknown, stUpdate> () )
#define SQLMofify (System::Set<TSQLToken, stUnknown, stUpdate> () )
extern PACKAGE Mysqlcp::TConvertChar DBCharSet;
extern PACKAGE bool dllVersion;
extern PACKAGE AnsiString dllVerStr;
extern PACKAGE TSQLToken __fastcall NextSQLToken(char * &p, /* out */ AnsiString &Token, TSQLToken CurSection
	);
extern PACKAGE bool __fastcall GetShow(const AnsiString SQL);
extern PACKAGE AnsiString __fastcall GetTable(const AnsiString SQL);
extern PACKAGE AnsiString __fastcall GetTableNamePartFromSQL(const AnsiString SQL);
extern PACKAGE AnsiString __fastcall GetSelectPartFromSQL(const AnsiString SQL);
extern PACKAGE AnsiString __fastcall GetWherePartFromSQL(const AnsiString SQL);
extern PACKAGE AnsiString __fastcall GetOrderByPartFromSQL(const AnsiString SQL);
extern PACKAGE int __fastcall mysql_reload(PMYSQL _mysql);
extern PACKAGE bool __fastcall CompareBegin(AnsiString Str1, AnsiString Str2);
extern PACKAGE System::TDateTime __fastcall SqlDateToDateTime(AnsiString Value);
extern PACKAGE AnsiString __fastcall DateTimeToSqlDate(System::TDateTime Value, int Mode);
extern PACKAGE System::TDateTime __fastcall SQLTimeStampToDateTime(AnsiString Value);
extern PACKAGE double __fastcall StrToSQLFloat(AnsiString Value);
extern PACKAGE AnsiString __fastcall SQLFloatToStr(double Value);
extern PACKAGE bool __fastcall StrToBool(const TTrueArray &TrueVal, const TFalseArray &FalseVal, AnsiString 
	Value);
extern PACKAGE void __fastcall GetToken(AnsiString &Buffer, AnsiString &Token);
extern PACKAGE void __fastcall ConvermySQLtoDelphiFieldInfo(PMYSQL_FIELD Info, Word Count, Word Offset
	, Bde::pFLDDesc pRecBuff, Bde::pVCHKDesc pValChk, AnsiString EnumVal);
extern PACKAGE bool __fastcall IS_ENUM(int F);
extern PACKAGE bool __fastcall IS_SET(int F);
extern PACKAGE void __fastcall LoadmySQLLibrary(void);
extern PACKAGE void __fastcall UnloadmySQLLibrary(void);

}	/* namespace Mysqltypes */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Mysqltypes;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// mySQLTypes
