// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'mySQLDbTables.pas' rev: 5.00

#ifndef mySQLDbTablesHPP
#define mySQLDbTablesHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <mySQLCP.hpp>	// Pascal unit
#include <mySQLTypes.hpp>	// Pascal unit
#include <SMIntf.hpp>	// Pascal unit
#include <mySQLAccess.hpp>	// Pascal unit
#include <StdVCL.hpp>	// Pascal unit
#include <DBTables.hpp>	// Pascal unit
#include <Bde.hpp>	// Pascal unit
#include <DBCommon.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Mysqldbtables
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TmySQLDACAbout;
class PASCALIMPLEMENTATION TmySQLDACAbout : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TmySQLDACAbout(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TmySQLDACAbout(void) { }
	#pragma option pop
	
};


typedef TParams TmySQLParams;
;

typedef TParam TmySQLParam;
;

typedef TMetaClass*TmySQLDatabaseClass;

typedef TMetaClass*TmySQLTableClass;

typedef TMetaClass*TmySQLQueryClass;

class DELPHICLASS EmySQLDatabaseError;
class PASCALIMPLEMENTATION EmySQLDatabaseError : public Db::EDatabaseError 
{
	typedef Db::EDatabaseError inherited;
	
private:
	Word FErrorCode;
	
public:
	__fastcall EmySQLDatabaseError(Mysqlaccess::TmySQLEngine* Engine, Word ErrorCode);
	__fastcall virtual ~EmySQLDatabaseError(void);
	__property Word ErrorCode = {read=FErrorCode, nodefault};
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EmySQLDatabaseError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Db::EDatabaseError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EmySQLDatabaseError(int Ident)/* overload */ : Db::EDatabaseError(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EmySQLDatabaseError(int Ident, const System::TVarRec 
		* Args, const int Args_Size)/* overload */ : Db::EDatabaseError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EmySQLDatabaseError(const AnsiString Msg, int AHelpContext
		) : Db::EDatabaseError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EmySQLDatabaseError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Db::EDatabaseError(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EmySQLDatabaseError(int Ident, int AHelpContext)/* overload */
		 : Db::EDatabaseError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EmySQLDatabaseError(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Db::EDatabaseError(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
};


class DELPHICLASS TmySQLDatabase;
typedef void __fastcall (__closure *TBaseDatabaseLoginEvent)(TmySQLDatabase* Database, Classes::TStrings* 
	LoginParams);

class DELPHICLASS TmySQLDataSet;
class PASCALIMPLEMENTATION TmySQLDatabase : public Db::TCustomConnection 
{
	typedef Db::TCustomConnection inherited;
	
private:
	TmySQLDACAbout* FAbout;
	Dbtables::TTransIsolation FTransIsolation;
	bool FKeepConnection;
	AnsiString FDatabaseName;
	AnsiString FUserName;
	AnsiString FUserPassword;
	unsigned FPort;
	AnsiString FHost;
	Mysqltypes::TConnectOptions FConnectOptions;
	Mysqlaccess::TmySQLEngine* FEngine;
	bool FTemporary;
	bool FAcquiredHandle;
	bool FPseudoIndexes;
	bool FHandleShared;
	bool FExclusive;
	bool FReadOnly;
	int FRefCount;
	Bde::_hDBIObj *FHandle;
	Classes::TStrings* FParams;
	Classes::TList* FStmtList;
	TBaseDatabaseLoginEvent FOnLogin;
	void __fastcall CheckActive(void);
	void __fastcall CheckInactive(void);
	void __fastcall CheckDatabase(AnsiString &Password);
	void __fastcall ClearStatements(void);
	void __fastcall EndTransaction(Bde::eXEnd TransEnd);
	bool __fastcall GetInTransaction(void);
	Dbtables::TTraceFlags __fastcall GetTraceFlags(void);
	void __fastcall Login(Classes::TStrings* LoginParams);
	void __fastcall ParamsChanging(System::TObject* Sender);
	void __fastcall SetDatabaseFlags(void);
	void __fastcall SetDatabaseName(const AnsiString Value);
	void __fastcall SetUserName(const AnsiString Value);
	void __fastcall SetUserPassword(const AnsiString Value);
	void __fastcall SetPort(const unsigned Value);
	void __fastcall SetHost(const AnsiString Value);
	void __fastcall SetKeepConnection(bool Value);
	void __fastcall SetExclusive(bool Value);
	void __fastcall SetHandle(Bde::hDBIDb Value);
	void __fastcall SetParams(Classes::TStrings* Value);
	void __fastcall SetReadOnly(bool Value);
	void __fastcall SetTraceFlags(Dbtables::TTraceFlags Value);
	TmySQLDatabase* __fastcall FindDatabase(const AnsiString DatabaseName);
	void __fastcall ValidateName(const AnsiString Name);
	
protected:
	void __fastcall CloseDatabaseHandle(void);
	void __fastcall CloseDatabase(void);
	virtual void __fastcall DoConnect(void);
	virtual void __fastcall DoDisconnect(void);
	virtual bool __fastcall GetConnected(void);
	HIDESBASE TmySQLDataSet* __fastcall GetDataSet(int Index);
	Mysqlaccess::TmySQLEngine* __fastcall Engine(void);
	virtual void __fastcall Loaded(void);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	void __fastcall InitEngine(void);
	void __fastcall AddDatabase(TmySQLDatabase* Value);
	void __fastcall RemoveDatabase(TmySQLDatabase* Value);
	
public:
	__fastcall virtual TmySQLDatabase(Classes::TComponent* AOwner);
	__fastcall virtual ~TmySQLDatabase(void);
	void __fastcall ApplyUpdates(TmySQLDataSet* const * DataSets, const int DataSets_Size);
	void __fastcall CloseDataSets(void);
	int __fastcall Execute(const AnsiString SQL, Db::TParams* Params, bool Cache, Bde::phDBICur Cursor)
		;
	void __fastcall Commit(void);
	void __fastcall Rollback(void);
	void __fastcall StartTransaction(void);
	void __fastcall GetTableNames(AnsiString Pattern, Classes::TStrings* List);
	AnsiString __fastcall GetClientInfo(void);
	AnsiString __fastcall GetServerStat(void);
	AnsiString __fastcall GetHostInfo(void);
	unsigned __fastcall GetProtoInfo(void);
	AnsiString __fastcall GetServerInfo(void);
	void __fastcall SelectDB(AnsiString DBName);
	Mysqlcp::TConvertChar __fastcall GetCharSet(void);
	int __fastcall Ping(void);
	void __fastcall Kill(int PID);
	void __fastcall GetDatabases(AnsiString Pattern, Classes::TStrings* List);
	__property TmySQLDataSet* DataSets[int Index] = {read=GetDataSet};
	__property Bde::hDBIDb Handle = {read=FHandle, write=SetHandle};
	__property bool InTransaction = {read=GetInTransaction, nodefault};
	__property bool Temporary = {read=FTemporary, write=FTemporary, nodefault};
	__property Dbtables::TTraceFlags TraceFlags = {read=GetTraceFlags, write=SetTraceFlags, nodefault};
		
	
__published:
	__property TmySQLDACAbout* About = {read=FAbout, write=FAbout};
	__property Connected ;
	__property AnsiString DatabaseName = {read=FDatabaseName, write=SetDatabaseName};
	__property AnsiString UserName = {read=FUserName, write=SetUserName};
	__property AnsiString UserPassword = {read=FUserPassword, write=SetUserPassword};
	__property unsigned Port = {read=FPort, write=SetPort, default=3306};
	__property AnsiString Host = {read=FHost, write=SetHost};
	__property Mysqltypes::TConnectOptions ConnectOptions = {read=FConnectOptions, write=FConnectOptions
		, nodefault};
	__property bool KeepConnection = {read=FKeepConnection, write=SetKeepConnection, default=1};
	__property bool Exclusive = {read=FExclusive, write=SetExclusive, default=0};
	__property bool HandleShared = {read=FHandleShared, write=FHandleShared, default=0};
	__property LoginPrompt ;
	__property Classes::TStrings* Params = {read=FParams, write=SetParams};
	__property bool ReadOnly = {read=FReadOnly, write=SetReadOnly, default=0};
	__property Dbtables::TTransIsolation TransIsolation = {read=FTransIsolation, write=FTransIsolation, 
		default=1};
	__property AfterConnect ;
	__property AfterDisconnect ;
	__property BeforeConnect ;
	__property BeforeDisconnect ;
	__property TBaseDatabaseLoginEvent OnLogin = {read=FOnLogin, write=FOnLogin};
};


class DELPHICLASS TmySQLSQLUpdateObject;
class PASCALIMPLEMENTATION TmySQLSQLUpdateObject : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
protected:
	virtual TmySQLDataSet* __fastcall GetDataSet(void) = 0 ;
	virtual void __fastcall SetDataSet(TmySQLDataSet* ADataSet) = 0 ;
	virtual void __fastcall Apply(Db::TUpdateKind UpdateKind) = 0 ;
	virtual Classes::TStrings* __fastcall GetSQL(Db::TUpdateKind UpdateKind) = 0 ;
	__property TmySQLDataSet* DataSet = {read=GetDataSet, write=SetDataSet};
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TmySQLSQLUpdateObject(Classes::TComponent* AOwner
		) : Classes::TComponent(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TmySQLSQLUpdateObject(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TmySQLDataSet : public Db::TDataSet 
{
	typedef Db::TDataSet inherited;
	
private:
	Bde::_hDBIObj *FHandle;
	#pragma pack(push, 1)
	Bde::RECProps FRecProps;
	#pragma pack(pop)
	
	Bde::_hDBIObj *FStmtHandle;
	Bde::_hDBIObj *FExprFilter;
	Bde::_hDBIObj *FFuncFilter;
	char *FFilterBuffer;
	Word FIndexFieldMap[16];
	bool FExpIndex;
	bool FCaseInsIndex;
	bool FCachedUpdates;
	bool FInUpdateCallback;
	bool FCanModify;
	bool FCacheBlobs;
	Word FKeySize;
	Bde::DELAYUPDCbDesc *FUpdateCBBuf;
	Dbtables::TKeyBuffer *FKeyBuffers[6];
	Dbtables::TKeyBuffer *FKeyBuffer;
	Dbtables::TRecNoStatus FRecNoStatus;
	int FIndexFieldCount;
	Word FRecordSize;
	Word FBookmarkOfs;
	Word FRecInfoOfs;
	Word FBlobCacheOfs;
	Word FRecBufSize;
	int FBlockBufOfs;
	int FLastParentPos;
	char *FBlockReadBuf;
	char *FOldBuffer;
	TmySQLDataSet* FParentDataSet;
	TmySQLSQLUpdateObject* FUpdateObject;
	bool FAutoRefresh;
	Dbtables::TDBFlags FDBFlags;
	Db::TUpdateMode FUpdateMode;
	TmySQLDatabase* FDatabase;
	void __fastcall ClearBlobCache(char * Buffer);
	bool __fastcall GetActiveRecBuf(char * &RecBuf);
	AnsiString __fastcall GetBlobData(Db::TField* Field, char * Buffer);
	char * __fastcall GetOldRecord(void);
	void __fastcall InitBufferPointers(bool GetProps);
	short __stdcall RecordFilter(void * RecBuf, int RecNo);
	void __fastcall SetBlobData(Db::TField* Field, char * Buffer, AnsiString Value);
	Bde::hDBIDb __fastcall GetDBHandle(void);
	void __fastcall SetUpdateMode(const Db::TUpdateMode Value);
	void __fastcall SetAutoRefresh(const bool Value);
	void __fastcall SetDatabase(TmySQLDatabase* Value);
	TmySQLDatabase* __fastcall GetDatabase(void);
	void __fastcall SetupAutoRefresh(void);
	
protected:
	virtual void __fastcall PSEndTransaction(bool Commit);
	virtual int __fastcall PSExecuteStatement(const AnsiString ASQL, Db::TParams* AParams, void * ResultSet
		);
	virtual void __fastcall PSGetAttributes(Classes::TList* List);
	virtual AnsiString __fastcall PSGetQuoteChar(void);
	virtual bool __fastcall PSInTransaction(void);
	virtual bool __fastcall PSIsSQLBased(void);
	virtual bool __fastcall PSIsSQLSupported(void);
	virtual void __fastcall PSStartTransaction(void);
	virtual void __fastcall PSReset(void);
	virtual Db::EUpdateError* __fastcall PSGetUpdateException(Sysutils::Exception* E, Db::EUpdateError* 
		Prev);
	virtual Mysqlaccess::TmySQLEngine* __fastcall Engine(void) = 0 ;
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	void __fastcall ActivateFilters(void);
	void __fastcall AddFieldDesc(Dbtables::TFieldDescList FieldDescs, int &DescNo, int &FieldID, Classes::TBits* 
		RequiredFields, Db::TFieldDefs* FieldDefs);
	void __fastcall AllocCachedUpdateBuffers(bool Allocate);
	void __fastcall AllocKeyBuffers(void);
	virtual char * __fastcall AllocRecordBuffer(void);
	void __fastcall CheckSetKeyMode(void);
	virtual void __fastcall ClearCalcFields(char * Buffer);
	virtual void __fastcall CloseCursor(void);
	virtual void __fastcall CloseBlob(Db::TField* Field);
	Bde::hDBIFilter __fastcall CreateExprFilter(const AnsiString Expr, Db::TFilterOptions Options, int 
		Priority);
	Bde::hDBIFilter __fastcall CreateFuncFilter(void * FilterFunc, int Priority);
	virtual Bde::hDBICur __fastcall CreateHandle(void);
	Bde::hDBIFilter __fastcall CreateLookupFilter(Classes::TList* Fields, const Variant &Values, Db::TLocateOptions 
		Options, int Priority);
	virtual void __fastcall DataEvent(Db::TDataEvent Event, int Info);
	void __fastcall DeactivateFilters(void);
	virtual void __fastcall DestroyHandle(void);
	virtual void __fastcall DestroyLookupCursor(void);
	virtual bool __fastcall FindRecord(bool Restart, bool GoForward);
	void __fastcall FreeKeyBuffers(void);
	virtual void __fastcall FreeRecordBuffer(char * &Buffer);
	virtual void __fastcall GetBookmarkData(char * Buffer, void * Data);
	virtual Db::TBookmarkFlag __fastcall GetBookmarkFlag(char * Buffer);
	virtual bool __fastcall GetCanModify(void);
	virtual AnsiString __fastcall GetFieldFullName(Db::TField* Field);
	Db::TField* __fastcall GetIndexField(int Index);
	int __fastcall GetIndexFieldCount(void);
	virtual bool __fastcall GetIsIndexField(Db::TField* Field);
	Dbtables::PKeyBuffer __fastcall GetKeyBuffer(Dbtables::TKeyIndex KeyIndex);
	bool __fastcall GetKeyExclusive(void);
	int __fastcall GetKeyFieldCount(void);
	virtual Bde::hDBICur __fastcall GetLookupCursor(const AnsiString KeyFields, bool CaseInsensitive);
	virtual Db::TGetResult __fastcall GetRecord(char * Buffer, Db::TGetMode GetMode, bool DoCheck);
	virtual int __fastcall GetRecordCount(void);
	virtual int __fastcall GetRecNo(void);
	virtual Word __fastcall GetRecordSize(void);
	virtual Variant __fastcall GetStateFieldValue(Db::TDataSetState State, Db::TField* Field);
	void __fastcall GetObjectTypeNames(Db::TFields* Fields);
	bool __fastcall GetUpdatesPending(void);
	Db::TUpdateRecordTypes __fastcall GetUpdateRecordSet(void);
	Dbtables::PKeyBuffer __fastcall InitKeyBuffer(Dbtables::PKeyBuffer Buffer);
	virtual void __fastcall InitRecord(char * Buffer);
	virtual void __fastcall InternalAddRecord(void * Buffer, bool Append);
	virtual void __fastcall InternalCancel(void);
	virtual void __fastcall InternalClose(void);
	virtual void __fastcall InternalDelete(void);
	virtual void __fastcall InternalEdit(void);
	virtual void __fastcall InternalFirst(void);
	virtual void __fastcall InternalGotoBookmark(void * Bookmark);
	virtual void __fastcall InternalHandleException(void);
	virtual void __fastcall InternalInitFieldDefs(void);
	virtual void __fastcall InternalInitRecord(char * Buffer);
	virtual void __fastcall InternalInsert(void);
	virtual void __fastcall InternalLast(void);
	virtual void __fastcall InternalOpen(void);
	virtual void __fastcall InternalPost(void);
	virtual void __fastcall InternalRefresh(void);
	virtual void __fastcall InternalSetToRecord(char * Buffer);
	virtual bool __fastcall IsCursorOpen(void);
	virtual bool __fastcall LocateRecord(const AnsiString KeyFields, const Variant &KeyValues, Db::TLocateOptions 
		Options, bool SyncCursor);
	Word __fastcall LocateNearestRecord(const AnsiString KeyFields, const Variant &KeyValues, Db::TLocateOptions 
		Options, bool SyncCursor);
	bool __fastcall MapsToIndex(Classes::TList* Fields, bool CaseInsensitive);
	void __fastcall PostKeyBuffer(bool Commit);
	virtual void __fastcall PrepareCursor(void);
	Word __fastcall ProcessUpdates(Bde::DBIDelayedUpdCmd UpdCmd);
	bool __fastcall ResetCursorRange(void);
	virtual void __fastcall SetBookmarkData(char * Buffer, void * Data);
	virtual void __fastcall SetBookmarkFlag(char * Buffer, Db::TBookmarkFlag Value);
	void __fastcall SetCachedUpdates(bool Value);
	bool __fastcall SetCursorRange(void);
	virtual void __fastcall SetFieldData(Db::TField* Field, void * Buffer)/* overload */;
	void __fastcall SetFilterData(const AnsiString Text, Db::TFilterOptions Options);
	void __fastcall SetFilterHandle(Bde::hDBIFilter &Filter, Bde::hDBIFilter Value);
	virtual void __fastcall SetFiltered(bool Value);
	virtual void __fastcall SetFilterOptions(Db::TFilterOptions Value);
	virtual void __fastcall SetFilterText(const AnsiString Value);
	void __fastcall SetIndexField(int Index, Db::TField* Value);
	void __fastcall SetKeyBuffer(Dbtables::TKeyIndex KeyIndex, bool Clear);
	void __fastcall SetKeyExclusive(bool Value);
	void __fastcall SetKeyFieldCount(int Value);
	void __fastcall SetKeyFields(Dbtables::TKeyIndex KeyIndex, const System::TVarRec * Values, const int 
		Values_Size);
	void __fastcall SetLinkRanges(Classes::TList* MasterFields);
	virtual void __fastcall SetStateFieldValue(Db::TDataSetState State, Db::TField* Field, const Variant 
		&Value);
	virtual void __fastcall SetOnFilterRecord(const Db::TFilterRecordEvent Value);
	virtual void __fastcall SetRecNo(int Value);
	void __fastcall SetUpdateRecordSet(Db::TUpdateRecordTypes RecordTypes);
	void __fastcall SetUpdateObject(TmySQLSQLUpdateObject* Value);
	void __fastcall SwitchToIndex(const AnsiString IndexName, const AnsiString TagName);
	virtual void __fastcall Disconnect(void);
	virtual void __fastcall OpenCursor(bool InfoQuery);
	virtual bool __fastcall SetDBFlag(int Flag, bool Value);
	void __fastcall SetHandle(Bde::hDBICur Value);
	Bde::hDBICur __fastcall GetHandle(void);
	__property Dbtables::TDBFlags DBFlags = {read=FDBFlags, nodefault};
	__property Db::TUpdateMode UpdateMode = {read=FUpdateMode, write=SetUpdateMode, default=0};
	__property Bde::hDBIStmt StmtHandle = {read=FStmtHandle, write=FStmtHandle};
	
public:
	__fastcall virtual TmySQLDataSet(Classes::TComponent* AOwner);
	__fastcall virtual ~TmySQLDataSet(void);
	void __fastcall ApplyUpdates(void);
	virtual bool __fastcall BookmarkValid(void * Bookmark);
	virtual void __fastcall Cancel(void);
	void __fastcall CancelUpdates(void);
	__property bool CacheBlobs = {read=FCacheBlobs, write=FCacheBlobs, default=1};
	virtual int __fastcall CompareBookmarks(void * Bookmark1, void * Bookmark2);
	void __fastcall CommitUpdates(void);
	void __fastcall FetchAll(void);
	void __fastcall FlushBuffers(void);
	virtual bool __fastcall GetCurrentRecord(char * Buffer);
	virtual int __fastcall GetBlobFieldData(int FieldNo, Db::TBlobByteData &Buffer);
	virtual bool __fastcall GetFieldData(Db::TField* Field, void * Buffer)/* overload */;
	virtual bool __fastcall GetFieldData(int FieldNo, void * Buffer)/* overload */;
	void __fastcall GetIndexInfo(void);
	virtual bool __fastcall Locate(const AnsiString KeyFields, const Variant &KeyValues, Db::TLocateOptions 
		Options);
	virtual Variant __fastcall Lookup(const AnsiString KeyFields, const Variant &KeyValues, const AnsiString 
		ResultFields);
	virtual bool __fastcall IsSequenced(void);
	virtual void __fastcall Post(void);
	void __fastcall RevertRecord(void);
	virtual Db::TUpdateStatus __fastcall UpdateStatus(void);
	virtual int __fastcall Translate(char * Src, char * Dest, bool ToOem);
	bool __fastcall CheckOpen(Word Status);
	void __fastcall CloseDatabase(TmySQLDatabase* Database);
	void __fastcall GetDatabaseNames(Classes::TStrings* List);
	__property Bde::hDBIDb DBHandle = {read=GetDBHandle};
	__property Bde::hDBICur Handle = {read=GetHandle, write=SetHandle};
	__property bool ExpIndex = {read=FExpIndex, nodefault};
	__property Word KeySize = {read=FKeySize, nodefault};
	__property TmySQLSQLUpdateObject* UpdateObject = {read=FUpdateObject, write=SetUpdateObject};
	__property bool UpdatesPending = {read=GetUpdatesPending, nodefault};
	__property Db::TUpdateRecordTypes UpdateRecordTypes = {read=GetUpdateRecordSet, write=SetUpdateRecordSet
		, nodefault};
	
__published:
	__property bool AutoRefresh = {read=FAutoRefresh, write=SetAutoRefresh, default=0};
	__property TmySQLDatabase* Database = {read=GetDatabase, write=SetDatabase};
	__property Filter ;
	__property Filtered ;
	__property FilterOptions ;
	__property OnFilterRecord ;
	__property Active ;
	__property AutoCalcFields ;
	__property ObjectView ;
	__property BeforeOpen ;
	__property AfterOpen ;
	__property BeforeClose ;
	__property AfterClose ;
	__property BeforeInsert ;
	__property AfterInsert ;
	__property BeforeEdit ;
	__property AfterEdit ;
	__property BeforePost ;
	__property AfterPost ;
	__property BeforeCancel ;
	__property AfterCancel ;
	__property BeforeDelete ;
	__property AfterDelete ;
	__property BeforeScroll ;
	__property AfterScroll ;
	__property BeforeRefresh ;
	__property AfterRefresh ;
	__property OnCalcFields ;
	__property OnDeleteError ;
	__property OnEditError ;
	__property OnNewRecord ;
	__property OnPostError ;
};


#pragma option push -b-
enum TMySQLLockType { mltReadLock, mltWriteLock };
#pragma option pop

class DELPHICLASS TmySQLTable;
class PASCALIMPLEMENTATION TmySQLTable : public TmySQLDataSet 
{
	typedef TmySQLDataSet inherited;
	
private:
	TmySQLDACAbout* FAbout;
	bool FStoreDefs;
	Db::TIndexDefs* FIndexDefs;
	Db::TMasterDataLink* FMasterLink;
	bool FDefaultIndex;
	bool FExclusive;
	bool FReadOnly;
	bool FFieldsIndex;
	AnsiString FTableName;
	AnsiString FIndexName;
	Bde::_hDBIObj *FLookupHandle;
	AnsiString FLookupKeyFields;
	int FTableLevel;
	bool FLookupCaseIns;
	char FNativeTableName[261];
	int FLimit;
	int FOffset;
	void __fastcall SetLimit(const int Value);
	int __fastcall GetLimit(void);
	void __fastcall SetOffset(const int Value);
	int __fastcall GetOffset(void);
	void __fastcall CheckMasterRange(void);
	void __fastcall DecodeIndexDesc(const Bde::IDXDesc &IndexDesc, AnsiString &Source, AnsiString &Name
		, AnsiString &FieldExpression, AnsiString &DescFields, Db::TIndexOptions &Options);
	bool __fastcall FieldDefsStored(void);
	bool __fastcall GetExists(void);
	AnsiString __fastcall GetIndexFieldNames(void);
	AnsiString __fastcall GetIndexName(void);
	void __fastcall GetIndexParams(const AnsiString IndexName, bool FieldsIndex, AnsiString &IndexedName
		, AnsiString &IndexTag);
	AnsiString __fastcall GetMasterFields(void);
	char * __fastcall GetTableTypeName(void);
	int __fastcall GetTableLevel(void);
	bool __fastcall IndexDefsStored(void);
	void __fastcall MasterChanged(System::TObject* Sender);
	void __fastcall MasterDisabled(System::TObject* Sender);
	void __fastcall SetDataSource(Db::TDataSource* Value);
	void __fastcall SetExclusive(bool Value);
	void __fastcall SetIndexDefs(Db::TIndexDefs* Value);
	void __fastcall SetIndex(const AnsiString Value, bool FieldsIndex);
	void __fastcall SetIndexFieldNames(const AnsiString Value);
	void __fastcall SetIndexName(const AnsiString Value);
	void __fastcall SetMasterFields(const AnsiString Value);
	void __fastcall SetReadOnly(bool Value);
	void __fastcall SetTableLock(TMySQLLockType LockType, bool Lock);
	void __fastcall SetTableName(const AnsiString Value);
	AnsiString __fastcall GetTableName(void);
	void __fastcall UpdateRange(void);
	bool __fastcall GetBatchModify(void);
	void __fastcall SetBatchModify(const bool Value);
	
protected:
	virtual Db::TIndexDef* __fastcall PSGetDefaultOrder(void);
	virtual AnsiString __fastcall PSGetKeyFields(void);
	virtual AnsiString __fastcall PSGetTableName(void);
	virtual Db::TIndexDefs* __fastcall PSGetIndexDefs(Db::TIndexOptions IndexTypes);
	virtual void __fastcall PSSetCommandText(const AnsiString CommandText);
	virtual void __fastcall PSSetParams(Db::TParams* AParams);
	virtual Bde::hDBICur __fastcall CreateHandle(void);
	virtual void __fastcall DataEvent(Db::TDataEvent Event, int Info);
	virtual void __fastcall DefChanged(System::TObject* Sender);
	virtual void __fastcall DestroyHandle(void);
	virtual void __fastcall DestroyLookupCursor(void);
	virtual void __fastcall DoOnNewRecord(void);
	void __fastcall EncodeFieldDesc(Bde::FLDDesc &FieldDesc, const AnsiString Name, Db::TFieldType DataType
		, int Size, int Precision);
	void __fastcall EncodeIndexDesc(Bde::IDXDesc &IndexDesc, const AnsiString Name, const AnsiString FieldExpression
		, Db::TIndexOptions Options, const AnsiString DescFields);
	virtual bool __fastcall GetCanModify(void);
	virtual Db::TDataSource* __fastcall GetDataSource(void);
	HIDESBASE Bde::hDBICur __fastcall GetHandle(const AnsiString IndexName, const AnsiString IndexTag);
		
	AnsiString __fastcall GetLanguageDriverName(void);
	virtual Bde::hDBICur __fastcall GetLookupCursor(const AnsiString KeyFields, bool CaseInsensitive);
	virtual void __fastcall InitFieldDefs(void);
	AnsiString __fastcall GetFileName(void);
	Dbtables::TTableType __fastcall GetTableType(void);
	char * __fastcall NativeTableName(void);
	virtual void __fastcall PrepareCursor(void);
	virtual void __fastcall UpdateIndexDefs(void);
	__property Db::TMasterDataLink* MasterLink = {read=FMasterLink};
	
public:
	__fastcall virtual TmySQLTable(Classes::TComponent* AOwner);
	__fastcall virtual ~TmySQLTable(void);
	virtual Mysqlaccess::TmySQLEngine* __fastcall Engine(void);
	virtual Classes::TStream* __fastcall CreateBlobStream(Db::TField* Field, Db::TBlobStreamMode Mode);
		
	virtual bool __fastcall IsSequenced(void);
	void __fastcall AddIndex(const AnsiString Name, const AnsiString Fields, Db::TIndexOptions Options, 
		const AnsiString DescFields);
	void __fastcall ApplyRange(void);
	void __fastcall CancelRange(void);
	void __fastcall CreateTable(void);
	void __fastcall DeleteIndex(const AnsiString Name);
	void __fastcall EditKey(void);
	void __fastcall EditRangeEnd(void);
	void __fastcall EditRangeStart(void);
	void __fastcall EmptyTable(void);
	bool __fastcall FindKey(const System::TVarRec * KeyValues, const int KeyValues_Size);
	void __fastcall FindNearest(const System::TVarRec * KeyValues, const int KeyValues_Size);
	virtual void __fastcall GetDetailLinkFields(Classes::TList* MasterFields, Classes::TList* DetailFields
		);
	void __fastcall GetIndexNames(Classes::TStrings* List);
	void __fastcall GotoCurrent(TmySQLTable* Table);
	bool __fastcall GotoKey(void);
	void __fastcall GotoNearest(void);
	void __fastcall LockTable(TMySQLLockType LockType);
	void __fastcall SetKey(void);
	void __fastcall SetRange(const System::TVarRec * StartValues, const int StartValues_Size, const System::TVarRec 
		* EndValues, const int EndValues_Size);
	void __fastcall SetRangeEnd(void);
	void __fastcall SetRangeStart(void);
	void __fastcall UnlockTable(void);
	__property bool Exists = {read=GetExists, nodefault};
	__property int IndexFieldCount = {read=GetIndexFieldCount, nodefault};
	__property Db::TField* IndexFields[int Index] = {read=GetIndexField, write=SetIndexField};
	__property bool KeyExclusive = {read=GetKeyExclusive, write=SetKeyExclusive, nodefault};
	__property int KeyFieldCount = {read=GetKeyFieldCount, write=SetKeyFieldCount, nodefault};
	__property int TableLevel = {read=GetTableLevel, write=FTableLevel, nodefault};
	__property bool BatchModify = {read=GetBatchModify, write=SetBatchModify, default=0};
	
__published:
	__property TmySQLDACAbout* About = {read=FAbout, write=FAbout};
	__property bool DefaultIndex = {read=FDefaultIndex, write=FDefaultIndex, default=1};
	__property bool Exclusive = {read=FExclusive, write=SetExclusive, default=0};
	__property FieldDefs  = {stored=FieldDefsStored};
	__property Db::TIndexDefs* IndexDefs = {read=FIndexDefs, write=SetIndexDefs, stored=IndexDefsStored
		};
	__property AnsiString IndexFieldNames = {read=GetIndexFieldNames, write=SetIndexFieldNames};
	__property AnsiString IndexName = {read=GetIndexName, write=SetIndexName};
	__property AnsiString MasterFields = {read=GetMasterFields, write=SetMasterFields};
	__property Db::TDataSource* MasterSource = {read=GetDataSource, write=SetDataSource};
	__property bool ReadOnly = {read=FReadOnly, write=SetReadOnly, default=0};
	__property bool StoreDefs = {read=FStoreDefs, write=FStoreDefs, default=0};
	__property AnsiString TableName = {read=GetTableName, write=SetTableName};
	__property UpdateMode ;
	__property UpdateObject ;
	__property int Limit = {read=GetLimit, write=SetLimit, default=-1};
	__property int Offset = {read=GetOffset, write=SetOffset, default=0};
};


class DELPHICLASS TmySQLQuery;
class PASCALIMPLEMENTATION TmySQLQuery : public TmySQLDataSet 
{
	typedef TmySQLDataSet inherited;
	
private:
	TmySQLDACAbout* FAbout;
	Classes::TStrings* FSQL;
	bool FPrepared;
	Db::TParams* FParams;
	AnsiString FText;
	Db::TDataLink* FDataLink;
	bool FLocal;
	int FRowsAffected;
	bool FUniDirectional;
	bool FRequestLive;
	char *FSQLBinary;
	bool FParamCheck;
	bool FExecSQL;
	bool FCheckRowsAffected;
	Bde::hDBICur __fastcall CreateCursor(bool GenHandle);
	Bde::hDBICur __fastcall GetQueryCursor(bool GenHandle);
	int __fastcall GetRowsAffected(void);
	void __fastcall PrepareSQL(char * Value);
	void __fastcall QueryChanged(System::TObject* Sender);
	void __fastcall ReadBinaryData(Classes::TStream* Stream);
	void __fastcall ReadParamData(Classes::TReader* Reader);
	void __fastcall RefreshParams(void);
	void __fastcall SetDataSource(Db::TDataSource* Value);
	void __fastcall SetQuery(Classes::TStrings* Value);
	Classes::TStrings* __fastcall GetQuery(void);
	void __fastcall SetParamsList(Db::TParams* Value);
	Db::TParams* __fastcall GetParamsList(void);
	void __fastcall SetParamsFromCursor(void);
	void __fastcall SetPrepared(bool Value);
	void __fastcall SetPrepare(bool Value);
	void __fastcall WriteBinaryData(Classes::TStream* Stream);
	void __fastcall WriteParamData(Classes::TWriter* Writer);
	void __fastcall SetRequestLive(const bool Value);
	bool __fastcall GetRequestLive(void);
	
protected:
	virtual void __fastcall PSExecute(void);
	virtual Db::TIndexDef* __fastcall PSGetDefaultOrder(void);
	virtual Db::TParams* __fastcall PSGetParams(void);
	virtual AnsiString __fastcall PSGetTableName(void);
	virtual void __fastcall PSSetCommandText(const AnsiString CommandText);
	virtual void __fastcall PSSetParams(Db::TParams* AParams);
	virtual Bde::hDBICur __fastcall CreateHandle(void);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	virtual void __fastcall Disconnect(void);
	virtual void __fastcall FreeStatement(void);
	virtual Db::TDataSource* __fastcall GetDataSource(void);
	Word __fastcall GetParamsCount(void);
	virtual bool __fastcall SetDBFlag(int Flag, bool Value);
	virtual void __fastcall GetStatementHandle(char * SQLText);
	virtual bool __fastcall LocateRecord(const AnsiString KeyFields, const Variant &KeyValues, Db::TLocateOptions 
		Options, bool SyncCursor);
	__property Db::TDataLink* DataLink = {read=FDataLink};
	
public:
	__fastcall virtual TmySQLQuery(Classes::TComponent* AOwner);
	__fastcall virtual ~TmySQLQuery(void);
	virtual Mysqlaccess::TmySQLEngine* __fastcall Engine(void);
	virtual Classes::TStream* __fastcall CreateBlobStream(Db::TField* Field, Db::TBlobStreamMode Mode);
		
	virtual bool __fastcall IsSequenced(void);
	void __fastcall ExecSQL(void);
	virtual void __fastcall GetDetailLinkFields(Classes::TList* MasterFields, Classes::TList* DetailFields
		);
	Db::TParam* __fastcall ParamByName(const AnsiString Value);
	void __fastcall Prepare(void);
	void __fastcall UnPrepare(void);
	__property bool Prepared = {read=FPrepared, write=SetPrepare, nodefault};
	__property Word ParamCount = {read=GetParamsCount, nodefault};
	__property bool Local = {read=FLocal, nodefault};
	__property StmtHandle ;
	__property AnsiString Text = {read=FText};
	__property int RowsAffected = {read=GetRowsAffected, nodefault};
	__property char * SQLBinary = {read=FSQLBinary, write=FSQLBinary};
	
__published:
	__property TmySQLDACAbout* About = {read=FAbout, write=FAbout};
	__property Db::TDataSource* DataSource = {read=GetDataSource, write=SetDataSource};
	__property bool ParamCheck = {read=FParamCheck, write=FParamCheck, default=1};
	__property bool RequestLive = {read=GetRequestLive, write=SetRequestLive, default=0};
	__property Classes::TStrings* SQL = {read=GetQuery, write=SetQuery};
	__property Db::TParams* Params = {read=GetParamsList, write=SetParamsList, stored=false};
	__property bool UniDirectional = {read=FUniDirectional, write=FUniDirectional, default=0};
	__property UpdateMode ;
	__property UpdateObject ;
};


class DELPHICLASS TmySQLUpdateSQL;
class PASCALIMPLEMENTATION TmySQLUpdateSQL : public TmySQLSQLUpdateObject 
{
	typedef TmySQLSQLUpdateObject inherited;
	
private:
	TmySQLDACAbout* FAbout;
	TmySQLDataSet* FDataSet;
	TmySQLQuery* FQueries[3];
	Classes::TStrings* FSQLText[3];
	TmySQLQuery* __fastcall GetQuery(Db::TUpdateKind UpdateKind);
	Classes::TStrings* __fastcall GetSQLIndex(int Index);
	void __fastcall SetSQL(Db::TUpdateKind UpdateKind, Classes::TStrings* Value);
	void __fastcall SetSQLIndex(int Index, Classes::TStrings* Value);
	
protected:
	virtual Classes::TStrings* __fastcall GetSQL(Db::TUpdateKind UpdateKind);
	TMetaClass* __fastcall GetQueryClass(void);
	virtual TmySQLDataSet* __fastcall GetDataSet(void);
	virtual void __fastcall SetDataSet(TmySQLDataSet* ADataSet);
	void __fastcall SQLChanged(System::TObject* Sender);
	
public:
	__fastcall virtual TmySQLUpdateSQL(Classes::TComponent* AOwner);
	__fastcall virtual ~TmySQLUpdateSQL(void);
	virtual void __fastcall Apply(Db::TUpdateKind UpdateKind);
	void __fastcall ExecSQL(Db::TUpdateKind UpdateKind);
	void __fastcall SetParams(Db::TUpdateKind UpdateKind);
	__property DataSet ;
	__property TmySQLQuery* Query[Db::TUpdateKind UpdateKind] = {read=GetQuery};
	__property Classes::TStrings* SQL[Db::TUpdateKind UpdateKind] = {read=GetSQL, write=SetSQL};
	
__published:
	__property TmySQLDACAbout* About = {read=FAbout, write=FAbout};
	__property Classes::TStrings* ModifySQL = {read=GetSQLIndex, write=SetSQLIndex, index=0};
	__property Classes::TStrings* InsertSQL = {read=GetSQLIndex, write=SetSQLIndex, index=1};
	__property Classes::TStrings* DeleteSQL = {read=GetSQLIndex, write=SetSQLIndex, index=2};
};


class DELPHICLASS TmySQLBlobStream;
class PASCALIMPLEMENTATION TmySQLBlobStream : public Classes::TStream 
{
	typedef Classes::TStream inherited;
	
private:
	Db::TBlobField* FField;
	TmySQLDataSet* FDataSet;
	char *FBuffer;
	Db::TBlobStreamMode FMode;
	int FFieldNo;
	bool FOpened;
	bool FModified;
	int FPosition;
	AnsiString FBlobData;
	bool FCached;
	int FCacheSize;
	int __fastcall GetBlobSize(void);
	
public:
	__fastcall TmySQLBlobStream(Db::TBlobField* Field, Db::TBlobStreamMode Mode);
	__fastcall virtual ~TmySQLBlobStream(void);
	Mysqlaccess::TmySQLEngine* __fastcall Engine(void);
	virtual int __fastcall Read(void *Buffer, int Count);
	virtual int __fastcall Write(const void *Buffer, int Count);
	virtual int __fastcall Seek(int Offset, Word Origin);
	void __fastcall Truncate(void);
};


//-- var, const, procedure ---------------------------------------------------
#define VERSION "1.9.5 (Build 5046)"
extern PACKAGE Classes::TList* DBList;
extern PACKAGE AnsiString __fastcall sIF(bool b, const AnsiString s1, const AnsiString s2);
extern PACKAGE void __fastcall RegisterBDEInitProc(const Dbtables::TBDEInitProc InitProc);
extern PACKAGE bool __fastcall GetFieldSource(Db::TDataSet* ADataSet, Bde::DataSources &ADataSources
	);
extern PACKAGE bool __fastcall IsDirectory(const AnsiString DatabaseName);

}	/* namespace Mysqldbtables */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Mysqldbtables;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// mySQLDbTables
